package cn.com.duiba.anticheat.center.biz.dao.rules;

import java.util.List;

import cn.com.duiba.anticheat.center.biz.entity.rules.RuleConfigEntity;

/**
 * Created by sty on 2018/7/24.
 */
public interface RuleConfigDao {

  /**
   * 插入一个规则
   * @param entity
   * @return
   */
  RuleConfigEntity insert(RuleConfigEntity entity);

  /**
   * 更新一个规则
   * @param entity
   * @return
   */
  int update(RuleConfigEntity entity);

  /**
   * 根据场景查询所有规则
   * @return
   */
  List<RuleConfigEntity> getRuleByScene(Integer scene);

  /**
   * 查询所有的开启的规则
   * @return
   */
  List<RuleConfigEntity> getAllRule();


  /**
   * 根据规则名字修改对应规则状态对应的规则
   * @param ruleName
   * @return
   */
  int updateRuleByName(String ruleName,Integer status);

  /**
   * 根据规则名称查询规则
   * @param ruleName
   * @return
   */
  RuleConfigEntity getByRuleName(String ruleName);
}
