package cn.com.duiba.anticheat.center.biz.remoteservice.activity.impl;

import cn.com.duiba.anticheat.center.api.dto.ActivityBlackListDto;
import cn.com.duiba.anticheat.center.api.param.ActivityBlackListInsertParam;
import cn.com.duiba.anticheat.center.api.remoteservice.activity.RemoteActivityBlackListService;
import cn.com.duiba.anticheat.center.biz.service.activity.ActivityBlackListService;
import cn.com.duiba.boot.exception.BizException;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.RestController;

/**
 * @author XuJing
 * @since 2020/4/10 3:28 下午
 */
@RestController
public class RemoteActivityBlackListServiceImpl implements RemoteActivityBlackListService {
    @Autowired
    private ActivityBlackListService activityBlackListService;

    @Override
    public Long insert(ActivityBlackListInsertParam record) throws BizException {
        ActivityBlackListDto dto = new ActivityBlackListDto();
        BeanUtils.copyProperties(record, dto);
        return activityBlackListService.insert(dto);
    }

    @Override
    public Boolean findByCustomerId(Long customerId) throws BizException {
        return activityBlackListService.findByCustomerId(customerId);
    }

    @Override
    public Long deleteByCustomerId(Long customerId) throws BizException {
        return activityBlackListService.deleteByCustomerId(customerId);
    }
}
