package cn.com.duiba.anticheat.center.biz.remoteservice.rules.impl;

import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.web.bind.annotation.RestController;

import cn.com.duiba.anticheat.center.api.model.HelpCodeModel;
import cn.com.duiba.anticheat.center.api.remoteservice.rules.RemoteHelpCollectService;
import cn.com.duiba.anticheat.center.biz.enums.AnticheatSwitchEnum;
import cn.com.duiba.anticheat.center.biz.service.rules.DataServerHandler;
import cn.com.duiba.anticheat.center.biz.service.rules.DataServerHandlerManager;
import cn.com.duiba.boot.perftest.PerfTestContext;

/**
 * Created by sty on 2018/8/8.
 */
@RestController
public class RemoteHelpCollectServiceImpl implements RemoteHelpCollectService {

  private static final Logger LOGGER = LoggerFactory.getLogger(RemoteHelpCollectServiceImpl.class);

  @Override
  public void countUserTimesWithIp(Long consumerId, Long appId, Long activityId, String ip, Long helpConsumerId){
    //该接口不可用
  }

  @Override
  public void countHelp(HelpCodeModel model) {
    try {
      //给用户助力的次数
      DataServerHandler beHelpedHandler = DataServerHandlerManager
          .getHandler(AnticheatSwitchEnum.USER_BE_HELPED.getCode());
      if(beHelpedHandler!=null){
        beHelpedHandler.countService(model);
      }

      //根据ip统计的用户次数
      DataServerHandler ipUaMaxHelpedHandler = DataServerHandlerManager
          .getHandler(AnticheatSwitchEnum.USER_MAX_IP_UA_HELPED.getCode());
      if(ipUaMaxHelpedHandler!=null){
        ipUaMaxHelpedHandler.countService(model);
      }

      //根据ip助力的最大次数
      DataServerHandler ipTotalHelpedHandler = DataServerHandlerManager
          .getHandler(AnticheatSwitchEnum.USER_IP_TOTAL_HELPED.getCode());
      if(ipTotalHelpedHandler!=null){
        ipTotalHelpedHandler.countService(model);
      }

      //每天用户的邀请人数
      DataServerHandler dayInviteUserHandler = DataServerHandlerManager
          .getHandler(AnticheatSwitchEnum.DAY_INVITE_USERNUM.getCode());
      if(dayInviteUserHandler!=null){
        dayInviteUserHandler.countService(model);
      }
    }catch(Exception e){
      if(PerfTestContext.isCurrentInPerfTestMode()){
        LOGGER.info("助力统计出错",e);
      }else {
        LOGGER.warn("助力统计出错",e);
      }
    }
  }


}
