package cn.com.duiba.anticheat.center.biz.scheduler;

import cn.com.duiba.anticheat.center.biz.strategy.activity.impl.AnticheatLotteryLessOneSecStrategy;
import cn.com.duiba.anticheat.center.biz.strategy.goods.impl.AnticheatSameCreditsAddUpStrategy;
import cn.com.duiba.anticheat.center.biz.strategy.goods.impl.AnticheatSameIpStrategy;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AnticheatMapClearJob {

    private static final Logger LOGGER = LoggerFactory.getLogger(AnticheatMapClearJob.class);

    public void execute() {
        try {
            AnticheatSameCreditsAddUpStrategy.clearMap();
            AnticheatSameIpStrategy.clearMap();
            AnticheatLotteryLessOneSecStrategy.clearMap();
        } catch (Exception e) {
            LOGGER.error("防作弊每日清空内存记录，异常", e);
            return;
        }
        LOGGER.info("防作弊每日清空内存记录，执行");
    }
}
