package cn.com.duiba.anticheat.center.biz.service;

import cn.com.duiba.anticheat.center.biz.dao.goods.AnticheatAlarmConfigDao;
import cn.com.duiba.anticheat.center.biz.entity.goods.AnticheatAlarmConfigEntity;
import com.google.common.cache.CacheBuilder;
import com.google.common.cache.CacheLoader;
import com.google.common.cache.LoadingCache;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

import java.util.concurrent.TimeUnit;

@Service
public class AnticheatAlarmConfigService {

    @Autowired
    private AnticheatAlarmConfigDao anticheatAlarmConfigDao;

    private LoadingCache<String, AnticheatAlarmConfigEntity> cache = CacheBuilder.newBuilder().expireAfterWrite(1, TimeUnit.MINUTES).build(new CacheLoader<String, AnticheatAlarmConfigEntity>() {
        public AnticheatAlarmConfigEntity load(String type) throws Exception {
            return anticheatAlarmConfigDao.findByName(type);
        }

    });

    public AnticheatAlarmConfigEntity getCacheConfig(String type) {
        return cache.getUnchecked(type);
    }

}
