package cn.com.duiba.anticheat.center.biz.service.hbase;

import cn.com.duiba.anticheat.center.biz.entity.hbase.HbaseBatchPutEntity;

import java.util.List;

/**
 * 兑吧风控Hbase表操作
 * <p>
 * Created by sunchangji on 2018/8/20.
 */
public interface DuibaHbaseRiskService {

    /**
     * 单个increase
     *
     * @param rowKey  hbase rowkey(主键)
     * @param incrNum 递增值
     * @return 增加后的值
     */
    Long increaseByKey(String rowKey, long incrNum);

    /**
     * 存在更新,不存在新增
     *
     * @param rowKey hbase rowkey(主键)
     * @param num
     */
    void upsert(String rowKey, long num);

    /**
     * 批量put操作
     *
     * @param putEntityList
     */
    void batchUpsert(List<HbaseBatchPutEntity> putEntityList);

    /**
     * 根据rowkey查询num(LON_COLUMN列)
     *
     * @param rowkey
     * @return null标识不存在
     */
    Long findByRowKey(String rowkey);

}
