package cn.com.duiba.anticheat.center.biz.service.hbase.impl;

import cn.com.duiba.anticheat.center.biz.entity.hbase.HbaseBatchPutEntity;
import cn.com.duiba.anticheat.center.biz.service.hbase.DuibaHbaseRiskService;
import cn.com.duiba.anticheat.center.common.tool.HbaseRowKeyTool;
import cn.com.duiba.boot.perftest.PerfTestContext;
import org.apache.hadoop.hbase.client.Put;
import org.apache.hadoop.hbase.util.Bytes;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.data.hadoop.hbase.HbaseTemplate;
import org.springframework.stereotype.Service;

import javax.annotation.Resource;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.List;

/**
 * Created by sunchangji on 2018/8/20.
 */
@Service
public class DuibaHbaseRiskServiceImpl implements DuibaHbaseRiskService {
    private static final Logger LOGGER = LoggerFactory.getLogger(DuibaHbaseRiskServiceImpl.class);
    @Resource
    private HbaseTemplate hbaseTemplate;

    //表名
    private static final String TABLE_NAME = "duiba_risk";
    //压测模式表名
    private static final String PREF_TABLE_NAME = "pref_duiba_kv";
    //第一个列族
    private static final String FAMILY_NAME = "f1";
    //存储long的列名
    private static final String LONG_COLUMN = "l1";


    @Override
    public Long increaseByKey(String rowKey, long incrNum) {
        String newRowKey = HbaseRowKeyTool.handleRowKey(rowKey);
        try {
            return hbaseTemplate.execute(this.getTableName(), htable -> {
                Charset charset = hbaseTemplate.getCharset();
                return htable.incrementColumnValue(newRowKey.getBytes(charset), FAMILY_NAME.getBytes(charset), LONG_COLUMN.getBytes(charset), incrNum);
            });
        } catch (Exception e) {
            LOGGER.warn("Hbase increaseByKey error,rowkey={}", rowKey, e);
            return null;
        }
    }

    @Override
    public void upsert(String rowKey, long num) {
        String newRowKey = HbaseRowKeyTool.handleRowKey(rowKey);
        //新增数据
        hbaseTemplate.put(this.getTableName(), newRowKey, FAMILY_NAME, LONG_COLUMN, Bytes.toBytes(num));
    }

    @Override
    public void batchUpsert(List<HbaseBatchPutEntity> putEntityList) {
        hbaseTemplate.execute(this.getTableName(), htable -> {
            List<Put> puts = new ArrayList<>(putEntityList.size());
            Charset charset = hbaseTemplate.getCharset();
            for (HbaseBatchPutEntity entity : putEntityList) {
                String rowKey = HbaseRowKeyTool.handleRowKey(entity.getRowKey());
                long value = entity.getIncrNum();
                puts.add(new Put(rowKey.getBytes(charset)).addColumn(FAMILY_NAME.getBytes(charset), LONG_COLUMN.getBytes(charset), Bytes.toBytes(value)));
            }
            htable.put(puts);
            return true;
        });
    }

    @Override
    public Long findByRowKey(String rowKey) {
        String newRowKey = HbaseRowKeyTool.handleRowKey(rowKey);
        try {
            return hbaseTemplate.get(this.getTableName(), newRowKey, FAMILY_NAME, LONG_COLUMN, (result, rowNum) -> {
                if (result.isEmpty()) {
                    return null;
                }
                return Bytes.toLong(result.value());
            });
        } catch (Exception e) {
            LOGGER.warn("Hbase findByRowKey error,rowKey={}", newRowKey, e);
            return null;
        }
    }

    private String getTableName(){
        if (PerfTestContext.isCurrentInPerfTestMode()) {
            return PREF_TABLE_NAME;
        }
        return TABLE_NAME;
    }

}
