package cn.com.duiba.anticheat.center.biz.service.risk.impl;

import cn.com.duiba.anticheat.center.api.dto.ActRiskRechargeConfDto;
import cn.com.duiba.anticheat.center.api.param.ActRiskRechargeConfParam;
import cn.com.duiba.anticheat.center.biz.constant.RedisKeyFactory;
import cn.com.duiba.anticheat.center.biz.dao.risk.ActRiskRechargeConfDao;
import cn.com.duiba.anticheat.center.biz.entity.risk.ActRiskRechargeConfEntity;
import cn.com.duiba.anticheat.center.biz.service.risk.RiskActRechargeConfService;
import cn.com.duiba.boot.exception.BizException;
import cn.com.duiba.wolf.utils.BeanUtils;
import com.alibaba.fastjson.JSONObject;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.redis.core.StringRedisTemplate;
import org.springframework.stereotype.Service;

import javax.annotation.Resource;
import java.util.concurrent.TimeUnit;

/**
 * @description:
 * @author: lja
 * @date: Created on 2020/3/5 11:51
 * @version:
 */
@Service
public class RiskActRechargeConfServiceImpl implements RiskActRechargeConfService {

    @Resource
    private StringRedisTemplate stringRedisTemplate;

    @Autowired
    private ActRiskRechargeConfDao actRiskRechargeConfDao;


    @Override
    public boolean insertSelective(ActRiskRechargeConfDto dto) throws BizException {
        if (dto == null || dto.getActivityType() == null || StringUtils.isBlank(dto.getRelationId())) {
            throw new BizException("参数不可为空");
        }
        if (this.getByParam(dto) != null) {
            return false;
        }
        if(actRiskRechargeConfDao.insertSelective(BeanUtils.copy(dto, ActRiskRechargeConfEntity.class)) > 0){
            stringRedisTemplate.delete(getKey(dto.getActivityType(), dto.getRelationId()));
            return true;
        }
        return false;
    }

    @Override
    public boolean updateByPrimaryKeySelective(ActRiskRechargeConfDto dto) throws BizException {
        if (dto == null || dto.getId() == null) {
            throw new BizException("参数不可为空");
        }
        if (this.getByParam(dto) == null) {
            return false;
        }
        if (actRiskRechargeConfDao.updateByPrimaryKeySelective(BeanUtils.copy(dto, ActRiskRechargeConfEntity.class)) > 0) {
            ActRiskRechargeConfDto copy = BeanUtils.copy(this.getByParam(dto), ActRiskRechargeConfDto.class);
            String key = getKey(copy.getActivityType(), copy.getRelationId());
            if (key != null) {
                stringRedisTemplate.opsForValue().set(key, JSONObject.toJSONString(copy), 5, TimeUnit.MINUTES);
            }
            return true;
        }
        return false;
    }


    @Override
    public ActRiskRechargeConfDto selectByParam(String relationId, Long activityType) throws BizException {
        if (activityType == null || StringUtils.isBlank(relationId)) {
            throw new BizException("参数不可为空");
        }
        String key = getKey(activityType, relationId);
        String value = stringRedisTemplate.opsForValue().get(key);
        if (StringUtils.isNotBlank(value)) {
            return JSONObject.parseObject(value,ActRiskRechargeConfDto.class);
        }
        ActRiskRechargeConfParam param  = new ActRiskRechargeConfParam();
        param.setRelationId(relationId);
        param.setActivityType(activityType);
        ActRiskRechargeConfDto dto = BeanUtils.copy(actRiskRechargeConfDao.selectByParam(param), ActRiskRechargeConfDto.class);

        stringRedisTemplate.opsForValue().set(key,JSONObject.toJSONString(dto),5,TimeUnit.MINUTES);
        return dto;
    }





    private String getKey(Long activityType, String relationId) {
        if (activityType == null || relationId == null) {
            return null;
        }
        return String.format("%s%s_%s", RedisKeyFactory.K033.toString(), activityType, relationId);
    }


    private ActRiskRechargeConfEntity getByParam(ActRiskRechargeConfDto dto) {

        ActRiskRechargeConfParam param = new ActRiskRechargeConfParam();
        param.setActivityType(dto.getActivityType());
        param.setRelationId(dto.getRelationId());
        param.setId(dto.getId());
        return actRiskRechargeConfDao.selectByParam(param);
    }


    @Override
    public ActRiskRechargeConfDto selectById(Long id) throws BizException {
        if(id == null){
            throw new BizException("参数为空");
        }
        ActRiskRechargeConfParam param = new ActRiskRechargeConfParam();
        param.setId(id);
        return BeanUtils.copy(actRiskRechargeConfDao.selectByParam(param),ActRiskRechargeConfDto.class) ;
    }

}