package cn.com.duiba.anticheat.center.biz.service.risk.impl;

import cn.com.duiba.anticheat.center.api.dto.CustomRiskBO;
import cn.com.duiba.anticheat.center.api.dto.RiskRuleEngineResultDto;
import cn.com.duiba.anticheat.center.api.enums.RiskDecisionEnum;
import cn.com.duiba.anticheat.center.api.enums.RiskSceneMappingEnum;
import cn.com.duiba.anticheat.center.api.param.RiskRuleEngineParam;
import cn.com.duiba.anticheat.center.api.param.RiskRuleParam;
import cn.com.duiba.anticheat.center.biz.service.risk.RiskRuleEngineService;
import cn.com.duiba.anticheat.center.common.exceptions.AnticheatException;
import cn.com.duiba.boot.utils.SpringEnvironmentUtils;
import cn.com.duiba.developer.center.api.utils.WhiteAccessUtil;
import cn.com.duiba.tuia.risk.engine.api.remote.RemoteRuleEngineService;
import cn.com.duiba.tuia.risk.engine.api.req.DuiBaRuleEngineParam;
import cn.com.duiba.tuia.risk.engine.api.rsp.RuleEngineResult;
import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import org.apache.commons.codec.digest.DigestUtils;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Service;

import javax.annotation.Resource;
import java.util.List;
import java.util.Objects;


/**
 * Created by fangdong on 2019/02/22
 */
@Service("riskRuleEngineService")
public class RiskRuleEngineServiceImpl implements RiskRuleEngineService {
    private static final Logger log = LoggerFactory.getLogger(RiskRuleEngineServiceImpl.class);

    private static final String SOURCE = "duiba";

    /**
     * 定制风控业务白名单
     */
    private static final String CUSTOM_RISK = "DZFK_lvcong";

    @Resource
    private RemoteRuleEngineService remoteRuleEngineService;



    @Override
    public RiskRuleEngineResultDto execute(RiskRuleParam param) {
        if (param == null) {
            throw new AnticheatException("参数错误");
        }

        DuiBaRuleEngineParam request = new DuiBaRuleEngineParam();
        // consumerId
        request.setConsumerId(param.getConsumerId().toString());
        // activityType
        request.setActivityType(param.getActivityType());
        // appId
        request.setMediaId(param.getAppId().toString());
        // activityId
        request.setActivityShortId(param.getActivityId());
        // operatingId
        request.setActivityId(param.getOperatingId());
        // sceneKey
        request.setSceneKey(param.getScene().getCode());
        // duibaScene
        request.setDuibaScene(param.getScene().getType());
        // date
        request.setDate(param.getDate());
        // ip
        request.setIp(param.getIp());
        // ua
        request.setUa(DigestUtils.md5Hex(param.getUa()));
        // platform
        request.setPlatform(param.getOs());
        // alipayAccount
        request.setAliPayAccount(param.getAliPayAccount());
        // alipayName
        request.setAliPayName(param.getAliPayName());
        // source
        request.setSource(SOURCE);
        // deviceId
        request.setDeviceId(param.getDeviceId());

        RuleEngineResult response = null;
        try {
            if (SpringEnvironmentUtils.isTestEnv() && log.isInfoEnabled()) {
                log.info("风控规则引擎 -入参：={}", JSONObject.toJSONString(request));
            }

            response = remoteRuleEngineService.operator4Duiba(request);
            if (response == null || !response.isSuccess()) {
                throw new AnticheatException("风控规则引擎执行异常");
            }
        } catch (Exception e) {
            log.error("风控规则引擎执行异常, param={}, request={}, response={}",
                    param, JSON.toJSONString(request), JSON.toJSONString(response), e);
            throw e;
        }

        RiskRuleEngineResultDto result = new RiskRuleEngineResultDto();
        result.setDecision(response.isReject() ? RiskDecisionEnum.REJECT : RiskDecisionEnum.ACCEPT);
        return result;
    }

    @Override
    public RiskRuleEngineResultDto executeByRoute(RiskRuleEngineParam param,String sceneKey) {
        if (param == null) {
            throw new AnticheatException("参数错误");
        }

        DuiBaRuleEngineParam request = new DuiBaRuleEngineParam();
        // consumerId
        request.setConsumerId(param.getConsumerId().toString());
        // activityType
        request.setActivityType(param.getActivityType());
        // appId
        request.setMediaId(param.getAppId().toString());
        // activityId
        request.setActivityShortId(param.getActivityId());
        // operatingId
        request.setActivityId(param.getOperatingId());
        // sceneKey
        request.setSceneKey(getSceneKey(param, sceneKey));
        // duibaScene
        request.setDuibaScene(RiskSceneMappingEnum.getEnumByActSence(param.getScene()).getType());
        // date
        request.setDate(param.getDate());
        // ip
        request.setIp(param.getIp());
        // ua
        request.setUa(StringUtils.isBlank(param.getUa()) ? null : DigestUtils.md5Hex(StringUtils.lowerCase(param.getUa())));
        // platform
        request.setPlatform(param.getOs());
        // alipayAccount
        request.setAliPayAccount(param.getAliPayAccount());
        // alipayName
        request.setAliPayName(param.getAliPayName());
        // source
        request.setSource(SOURCE);
        // deviceId
        request.setDeviceId(param.getDeviceId());

        // 2020-06-15 添加助力与兑换的字段 风控v2.4
        request.setAssistedUserId(param.getAssistedUserId());
        request.setItemId(param.getItemId());

        //手机号
        request.setPhone(param.getPhone());

        RuleEngineResult response = null;
        try {
            if (SpringEnvironmentUtils.isTestEnv() && log.isInfoEnabled()) {
                log.info("风控规则引擎 -入参：={}", JSONObject.toJSONString(request));
            }
            response = remoteRuleEngineService.operator4Duiba(request);
            if (response == null || !response.isSuccess()) {
                throw new AnticheatException("风控规则引擎执行异常");
            }
        } catch (Exception e) {
            log.error("风控规则引擎执行异常, param={}, request={}, response={}",
                    param, JSON.toJSONString(request), JSON.toJSONString(response), e);
            throw e;
        }

        RiskRuleEngineResultDto result = new RiskRuleEngineResultDto();
        result.setDecision(response.isReject() ? RiskDecisionEnum.REJECT : RiskDecisionEnum.ACCEPT);
        if(response.isReject() && log.isInfoEnabled()){
            log.info("风控拦截,参数={},sceneKey={}",JSONObject.toJSONString(param),sceneKey);
        }
        return result;
    }

    /**
     * 定制风控处理
     * 每个appId每种风控类型只能有一种定制风控
     *
     * @param param
     * @param sceneKey
     */
    public String getSceneKey(RiskRuleEngineParam param, String sceneKey) {
//        log.info("风控参数，param:{}, sceneKey:{}", JSON.toJSONString(param), sceneKey);
        if (Objects.isNull(param) || param.getAppId() == null || Objects.isNull(param.getScene())) {
            return sceneKey;
        }
        // 获取定制风控配置
        String riskConfigStr = WhiteAccessUtil.selectWhiteListJsonConfig(CUSTOM_RISK);
        if (StringUtils.isBlank(riskConfigStr)) {
            return sceneKey;
        }
        // 判断app是否有定制风控，后续如果json和appId有冲突，考虑改为阿波罗配置
        if (!riskConfigStr.contains(param.getAppId().toString())) {
            return sceneKey;
        }
        try {
            List<CustomRiskBO> customRiskBOList = JSON.parseArray(riskConfigStr, CustomRiskBO.class);
            if (CollectionUtils.isEmpty(customRiskBOList)) {
                return sceneKey;
            }
            // 匹配appId对应风控类型的风控场景标识
            for (CustomRiskBO customRiskBO : customRiskBOList) {
                // 过滤参数
                if (customRiskBO == null || customRiskBO.getRiskScene() == null || CollectionUtils.isEmpty(customRiskBO.getAppIds()) || StringUtils.isBlank(customRiskBO.getSceneKey())) {
                    continue;
                }
                // 定制风控场景key
                if (Objects.equals(customRiskBO.getRiskScene(), param.getScene().getValue()) && customRiskBO.getAppIds().contains(param.getAppId())) {
                    log.info("定制风控，param:{}, sceneKey:{}", JSON.toJSONString(param), customRiskBO.getSceneKey());
                    return customRiskBO.getSceneKey();
                }
            }
        } catch (Exception e) {
            log.warn("定制风控解析异常，走通用风控，param:{}, sceneKey:{}, riskConfig:{}", JSON.toJSONString(param), sceneKey, riskConfigStr, e);
        }
//        log.info("通用风控，param:{}, sceneKey:{}", JSON.toJSONString(param), sceneKey);
        return sceneKey;
    }

}

