package cn.com.duiba.anticheat.center.biz.service.rules.dataserverhandler;

import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

import java.util.Date;

import javax.annotation.PostConstruct;

import cn.com.duiba.anticheat.center.api.model.DuibaActivityModel;
import cn.com.duiba.anticheat.center.api.model.DuibaBaseModel;
import cn.com.duiba.anticheat.center.biz.constant.StatisticsConstant;
import cn.com.duiba.anticheat.center.biz.enums.AnticheatSwitchEnum;
import cn.com.duiba.anticheat.center.biz.enums.HbaseKeyEnum;
import cn.com.duiba.anticheat.center.biz.service.hbase.DuibaHbaseRiskService;
import cn.com.duiba.anticheat.center.biz.service.rules.DataServerHandler;
import cn.com.duiba.anticheat.center.biz.service.rules.DataServerHandlerManager;
import cn.com.duiba.anticheat.center.biz.service.rules.SwitchService;
import cn.com.duiba.wolf.utils.DateUtils;

/**
 * 单个IP对应cid数量
 * @author sty
 */
@Service
public class DayIpWithUserHandler implements DataServerHandler {



  @Autowired
  private SwitchService switchService;
  @Autowired
  private DuibaHbaseRiskService duibaHbaseRiskService;

  @PostConstruct
  public void init(){
    DataServerHandlerManager.registerHandler(this);
  }

  @Override
  public <T extends DuibaBaseModel> void countService(T model) {
    // This implementation is empty.
  }

  @Override
  public Long getService(DuibaActivityModel model) {
    return 0L;
  }

  @Override
  public Long setAndGetService(DuibaActivityModel model) {
    if(model == null){
      return 0L;
    }

    Long consumerId = model.getConsumerId();
    Long appId = model.getAppId();
    Long activityId = model.getActivityId();
    String ip = model.getIp();

    if(!switchService.getIsOpen(AnticheatSwitchEnum.DAY_IP_USERNUM) ||consumerId == null || appId == null || activityId == null || StringUtils
        .isBlank(ip)){
      //数据出错无法统计
      return 0L;
    }

    String hbaseUserKey = getDayIpUserHbaseKey(appId, activityId, ip, String.valueOf(consumerId));
    Long ipWithUser = duibaHbaseRiskService.findByRowKey(hbaseUserKey);

    String hbaseNumKey = getDayIpUserHbaseKey(appId, activityId, ip, StatisticsConstant.DAY_IP_WITH_USER_NUM);

    if(ipWithUser == null){
      duibaHbaseRiskService.upsert(hbaseUserKey, 1L);
      duibaHbaseRiskService.increaseByKey(hbaseNumKey, 1L);
    }
    return duibaHbaseRiskService.findByRowKey(hbaseNumKey);
  }

  private String getDayIpUserHbaseKey(Long appId, Long activityId, String ip, String key) {
    return HbaseKeyEnum.K010.toString() + appId + "_" + activityId + "_" + DateUtils.getDayStr(new Date()) + "_" + ip + "_" + key;
  }
  @Override
  public AnticheatSwitchEnum getServerNum() {
    return AnticheatSwitchEnum.DAY_IP_USERNUM;
  }
}
