package cn.com.duiba.anticheat.center.biz.service.rules.dataserverhandler;

import cn.com.duiba.anticheat.center.api.model.DuibaActivityModel;
import cn.com.duiba.anticheat.center.api.model.DuibaBaseModel;
import cn.com.duiba.anticheat.center.biz.constant.RedisKeyFactory;
import cn.com.duiba.anticheat.center.biz.enums.AnticheatSwitchEnum;
import cn.com.duiba.anticheat.center.biz.service.rules.DataServerHandler;
import cn.com.duiba.anticheat.center.biz.service.rules.DataServerHandlerManager;
import cn.com.duiba.anticheat.center.biz.service.rules.SwitchService;
import org.apache.commons.codec.digest.DigestUtils;
import org.apache.commons.lang3.StringUtils;
import org.joda.time.DateTime;
import org.springframework.data.redis.connection.RedisConnection;
import org.springframework.data.redis.connection.StringRedisConnection;
import org.springframework.data.redis.core.StringRedisTemplate;
import org.springframework.stereotype.Service;

import javax.annotation.PostConstruct;
import javax.annotation.Resource;
import java.util.List;

/**
 * Created by fangdong on 2019/04/12
 */
@Service
public class IpUaWithUserIn1DayHandler implements DataServerHandler {

    @Resource
    private StringRedisTemplate stringRedisTemplate;

    @Resource
    private SwitchService switchService;

    @PostConstruct
    public void init(){
        DataServerHandlerManager.registerHandler(this);
    }

    @Override
    public AnticheatSwitchEnum getServerNum() {
        return AnticheatSwitchEnum.IP_UA_CIDNUM_1DAY;
    }

    @Override
    public <T extends DuibaBaseModel> void countService(T model) {
        // This implementation is empty.
    }

    @Override
    public Long getService(DuibaActivityModel model) {
        return 0L;
    }

    @Override
    public Long setAndGetService(DuibaActivityModel model) {
        if (model == null) {
            return 0L;
        }

        Long consumerId = model.getConsumerId();
        Long appId = model.getAppId();
        Long activityId = model.getActivityId();
        String ip = model.getIp();
        String ua = model.getUa();

        if (!switchService.getIsOpen(AnticheatSwitchEnum.IP_UA_CIDNUM_1DAY) ||
                consumerId == null || appId == null || activityId == null || StringUtils.isBlank(ip) ||StringUtils.isBlank(ua)){
            //数据出错无法统计
            return 0L;
        }

        String redisKey = RedisKeyFactory.K016.toString() +
                appId + "_" + activityId + "_" + ip + "_" + DigestUtils.md5Hex(ua);

        List<Object> results = stringRedisTemplate.executePipelined((RedisConnection connection) -> {
            StringRedisConnection conn = (StringRedisConnection) connection;
            conn.sAdd(redisKey, String.valueOf(consumerId));
            conn.ttl(redisKey);
            conn.sCard(redisKey);
            return null;
        });

        Long ttl = (Long) results.get(1);
        Long count = (Long) results.get(2);

        if (ttl == -1) {
            stringRedisTemplate.expireAt(redisKey, DateTime.now().millisOfDay().withMaximumValue().toDate());
        }

        return count;
    }

}
