package cn.com.duiba.anticheat.center.biz.service.rules.impl;

import org.apache.commons.collections4.CollectionUtils;
import org.kie.api.KieBase;
import org.kie.api.runtime.KieSession;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Service;

import java.util.List;

import cn.com.duiba.anticheat.center.api.enums.RuleSceneEnum;
import cn.com.duiba.anticheat.center.biz.config.RuleAgendaListener;
import cn.com.duiba.anticheat.center.biz.service.rules.RuleExcuteService;

/**
 * Created by sty on 2018/7/25.
 */
@Service
public class RuleExcuteServiceImpl implements RuleExcuteService {

  private static final Logger LOGGER  = LoggerFactory.getLogger(RuleExcuteServiceImpl.class);


  @Override
  public boolean runRule(RuleSceneEnum scene, List<Object> objects){

    if(scene == null || CollectionUtils.isEmpty(objects)){
      return false;
    }

    KieBase kbase = KieComponent.getBaseByScene(scene.getType());
    if(kbase == null){
      return false;
    }
    //创建一个有状态的session
    KieSession session = kbase.newKieSession();
    try{
        RuleAgendaListener agendaListener = new RuleAgendaListener();
        session.addEventListener(agendaListener);

        objects.forEach(session::insert);
        session.fireAllRules();

        //一次性用的Object直接删除，防止内存泄漏
        objects.forEach(one-> session.delete(session.getFactHandle(one)));

        List<String> attachedRuleNames = agendaListener.getAts();

        return CollectionUtils.isNotEmpty(attachedRuleNames);

    }catch(Exception e){
      LOGGER.info("执行检测规则出错", e);
    }
    finally {
      session.dispose();
    }
    return false;
  }

}
