package cn.com.duiba.anticheat.center.biz.strategy.activity.impl;

import cn.com.duiba.anticheat.center.api.domain.activity.LotteryConsumerParams;
import cn.com.duiba.anticheat.center.api.domain.activity.LotteryOrderParams;
import cn.com.duiba.anticheat.center.api.domain.activity.LotteryRequestParams;
import cn.com.duiba.anticheat.center.biz.dao.activity.AnticheatLotteryDebugLogDao;
import cn.com.duiba.anticheat.center.biz.entity.activity.AnticheatLotteryDebugLogEntity;
import cn.com.duiba.anticheat.center.biz.entity.activity.AnticheatLotteryStrategyAppConfigEntity;
import cn.com.duiba.anticheat.center.biz.entity.activity.AnticheatLotteryStrategyConfigEntity;
import cn.com.duiba.anticheat.center.biz.strategy.activity.AnticheatLotteryStrategy;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

import java.util.Map;

/**
 * @author Yanf Guo
 */
@Component
public class AnticheatLotteryNotMobileStrategy implements AnticheatLotteryStrategy {

	@Autowired
	private AnticheatLotteryStrategyConfigService anticheatLotteryStrategyConfigService;

	@Autowired
	private AnticheatLotteryDebugLogDao anticheatLotteryDebugLogDao;

	@Override
	public int getEffectMode() {
		return anticheatLotteryStrategyConfigService.getCacheConfig(AnticheatLotteryStrategyConfigEntity.TYPE_NOT_MOBILE).getEffectMode();
	}

	@Override
	public boolean isEnable() {
		return anticheatLotteryStrategyConfigService.getCacheConfig(AnticheatLotteryStrategyConfigEntity.TYPE_NOT_MOBILE).getEnable();
	}

	@Override
	public boolean isAppEnable(Long appId) {
		Map<Long, AnticheatLotteryStrategyAppConfigEntity> map = anticheatLotteryStrategyConfigService.getCacheAppConfig(AnticheatLotteryStrategyConfigEntity.TYPE_NOT_MOBILE);
		if (!map.containsKey(appId)) {
			return false;
		}
		return true;
	}

	@Override
	public AnticheatLotteryStrategyResult checkLottery(LotteryConsumerParams consumer, LotteryOrderParams order, LotteryRequestParams request) {
		String ua = getOS(request.getUserAgent());
		if (!checkUa(ua)) {
			Long debugId = doMatchProcess(consumer, order, request);
			return new AnticheatLotteryStrategyResult(true, debugId);
		}
		return new AnticheatLotteryStrategyResult(false);
	}

	private String getOS(String ua) {
		if (ua == null) {
			return "Unkonwn";
		}
		ua = ua.toLowerCase();
		if (ua != null) {
			if (ua.contains("ipad")) {
				return "iPad";
			} else if (ua.contains("iphone")) {
				return "iPhone";
			} else if (ua.contains("android")) {
				return "Android";
			} else if (ua.contains("linux")) {
				return "Linux";
			} else if (ua.contains("windows")) {
				return "Windows";
			} else if (ua.contains("macintosh")) {
				return "Mac";
			}
		}
		return "Unknown";
	}
	
	private boolean checkUa(String ua) {
		if ("iPad".equals(ua)) {
			return true;
		}
		if ("iPhone".equals(ua)) {
			return true;
		}
		if ("Android".equals(ua)) {
			return true;
		}
		return false;
	}

	private Long doMatchProcess(LotteryConsumerParams consumer, LotteryOrderParams order, LotteryRequestParams request) {
		AnticheatLotteryDebugLogEntity debug = new AnticheatLotteryDebugLogEntity();
		debug.setStrategyType(AnticheatLotteryStrategyConfigEntity.TYPE_NOT_MOBILE);
		debug.setConsumerId(consumer.getConsumerId());
		debug.setPartnerUserId(consumer.getPartnerUserId());
		debug.setIp(request.getIp());
		debug.setLotteryOrderId(order.getLotteryOrderId());
		debug.setRelationId(order.getDuibaActivityId());
		debug.setRelationType(order.getType().value());
		debug.setOperatingActivityId(order.getOperatingActivityId());
		debug.setAppId(order.getAppId());
		debug.setMessage("本次抽奖非iPhone, Android, iPad");
		anticheatLotteryDebugLogDao.insert(debug);

		return debug.getId();
	}
}
