package cn.com.duiba.anticheat.center.biz.strategy.activity.impl;

import cn.com.duiba.anticheat.center.biz.dao.activity.AnticheatLotteryStrategyAppConfigDao;
import cn.com.duiba.anticheat.center.biz.dao.activity.AnticheatLotteryStrategyConfigDao;
import cn.com.duiba.anticheat.center.biz.entity.activity.AnticheatLotteryStrategyAppConfigEntity;
import cn.com.duiba.anticheat.center.biz.entity.activity.AnticheatLotteryStrategyConfigEntity;
import com.google.common.cache.CacheBuilder;
import com.google.common.cache.CacheLoader;
import com.google.common.cache.LoadingCache;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.TimeUnit;

@Service
public class AnticheatLotteryStrategyConfigService {

    @Autowired
    private AnticheatLotteryStrategyConfigDao anticheatLotteryStrategyConfigDao;

    @Autowired
    private AnticheatLotteryStrategyAppConfigDao anticheatLotteryStrategyAppConfigDao;

    private LoadingCache<String, AnticheatLotteryStrategyConfigEntity> cache = CacheBuilder.newBuilder().expireAfterWrite(1, TimeUnit.MINUTES).build(new CacheLoader<String, AnticheatLotteryStrategyConfigEntity>() {
        public AnticheatLotteryStrategyConfigEntity load(String type) throws Exception {
            return anticheatLotteryStrategyConfigDao.findByType(type);
        }

    });

    private LoadingCache<String, Map<Long, AnticheatLotteryStrategyAppConfigEntity>> apps = CacheBuilder.newBuilder().expireAfterWrite(1, TimeUnit.MINUTES).build(new CacheLoader<String, Map<Long, AnticheatLotteryStrategyAppConfigEntity>>() {
        public Map<Long, AnticheatLotteryStrategyAppConfigEntity> load(String type) throws Exception {
            List<AnticheatLotteryStrategyAppConfigEntity> list = anticheatLotteryStrategyAppConfigDao.findAllByType(type);
            Map<Long, AnticheatLotteryStrategyAppConfigEntity> map = new HashMap<Long, AnticheatLotteryStrategyAppConfigEntity>();
            for (AnticheatLotteryStrategyAppConfigEntity a : list) {
                map.put(a.getAppId(), a);
            }
            return map;
        }
    });

    public AnticheatLotteryStrategyConfigEntity getCacheConfig(String type) {
        return cache.getUnchecked(type);
    }

    public Map<Long, AnticheatLotteryStrategyAppConfigEntity> getCacheAppConfig(String type) {
        return apps.getUnchecked(type);
    }

    public List<AnticheatLotteryStrategyAppConfigEntity> getSelectAppsByType(String type) {
        return anticheatLotteryStrategyAppConfigDao.findAllByType(type);
    }
}
