package cn.com.duiba.anticheat.center.biz.strategy.activity.impl;

import cn.com.duiba.anticheat.center.api.domain.activity.LotteryConsumerParams;
import cn.com.duiba.anticheat.center.api.domain.activity.LotteryOrderParams;
import cn.com.duiba.anticheat.center.api.domain.activity.LotteryRequestParams;
import cn.com.duiba.anticheat.center.biz.entity.activity.AnticheatLotteryStrategyAppConfigEntity;
import cn.com.duiba.anticheat.center.biz.entity.activity.AnticheatLotteryStrategyConfigEntity;
import cn.com.duiba.anticheat.center.biz.strategy.activity.AnticheatLotteryStrategy;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

import java.util.Map;

/**
 * app白名单策略
 * Created by xiaoxuda on 2017/3/1.
 */
@Component
public class AnticheatLotteryWhiteAppStrategy implements AnticheatLotteryStrategy {
    @Autowired
    private AnticheatLotteryStrategyConfigService anticheatLotteryStrategyConfigService;

    @Override
    public int getEffectMode() {
        return anticheatLotteryStrategyConfigService.getCacheConfig(AnticheatLotteryStrategyConfigEntity.TYPE_WHITE_APP).getEffectMode();
    }

    @Override
    public boolean isEnable() {
        return anticheatLotteryStrategyConfigService.getCacheConfig(AnticheatLotteryStrategyConfigEntity.TYPE_WHITE_APP).getEnable();
    }

    @Override
    public boolean isAppEnable(Long appId) {
        Map<Long, AnticheatLotteryStrategyAppConfigEntity> map = anticheatLotteryStrategyConfigService
                .getCacheAppConfig(AnticheatLotteryStrategyConfigEntity.TYPE_WHITE_APP);
        return map.containsKey(appId);
    }

    @Override
    public AnticheatLotteryStrategyResult checkLottery(LotteryConsumerParams consumer, LotteryOrderParams order, LotteryRequestParams request) {
        if(isAppEnable(consumer.getAppId())){
            return new AnticheatLotteryStrategyResult(true);
        }else{
            return new AnticheatLotteryStrategyResult(false);
        }
    }
}
