package cn.com.duiba.anticheat.center.biz.strategy.activity.impl;

import cn.com.duiba.anticheat.center.api.domain.activity.LotteryConsumerParams;
import cn.com.duiba.anticheat.center.api.domain.activity.LotteryOrderParams;
import cn.com.duiba.anticheat.center.api.domain.activity.LotteryRequestParams;
import cn.com.duiba.anticheat.center.biz.dao.activity.AnticheatLotteryDebugLogDao;
import cn.com.duiba.anticheat.center.biz.dao.goods.AnticheatIpLimitDao;
import cn.com.duiba.anticheat.center.biz.entity.activity.AnticheatLotteryDebugLogEntity;
import cn.com.duiba.anticheat.center.biz.entity.activity.AnticheatLotteryStrategyAppConfigEntity;
import cn.com.duiba.anticheat.center.biz.entity.activity.AnticheatLotteryStrategyConfigEntity;
import cn.com.duiba.anticheat.center.biz.entity.goods.AnticheatIpLimitEntity;
import cn.com.duiba.anticheat.center.biz.strategy.activity.AnticheatLotteryStrategy;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

import java.util.Map;

/**
 * ip白名单接口
 * @author Yanf Guo
 */
@Component
public class AnticheatLotteryWhiteIpStrategy implements AnticheatLotteryStrategy {

    @Autowired
    private AnticheatLotteryStrategyConfigService anticheatLotteryStrategyConfigService;

    @Autowired
    private AnticheatLotteryDebugLogDao anticheatLotteryDebugLogDao;

    @Autowired
    private AnticheatIpLimitDao anticheatIpLimitDao;

    @Override
    public int getEffectMode() {
        return anticheatLotteryStrategyConfigService.getCacheConfig(AnticheatLotteryStrategyConfigEntity.TYPE_WHITE_IP).getEffectMode();
    }

    @Override
    public boolean isEnable() {
        return anticheatLotteryStrategyConfigService.getCacheConfig(AnticheatLotteryStrategyConfigEntity.TYPE_WHITE_IP).getEnable();
    }

    @Override
    public boolean isAppEnable(Long appId) {
        Map<Long, AnticheatLotteryStrategyAppConfigEntity> map = anticheatLotteryStrategyConfigService.getCacheAppConfig(AnticheatLotteryStrategyConfigEntity.TYPE_WHITE_IP);
        return map.containsKey(appId);
    }

    public AnticheatIpLimitEntity checkInWhiteList(String ip) {
        if (StringUtils.isNotBlank(ip)) {
            AnticheatIpLimitEntity record = anticheatIpLimitDao.findEnableWhiteIp(ip);
            if (record != null) {
                return record;
            }
            //IP网段查询
            String regionip = ip.substring(0, ip.lastIndexOf('.'));
            record = anticheatIpLimitDao.findEnableWhiteIp(regionip);
            if (record != null) {
                return record;
            }
        }
        return null;
    }

    @Override
    public AnticheatLotteryStrategyResult checkLottery(LotteryConsumerParams consumer, LotteryOrderParams order, LotteryRequestParams request) {
        String ip = request.getIp();
        if (StringUtils.isNotBlank(ip)) {
            AnticheatIpLimitEntity record = checkInWhiteList(ip);
            if (record != null) {
                Long debugId = doMatchProcess(consumer, order, request);
                return new AnticheatLotteryStrategyResult(true, debugId);
            }
        }
        return new AnticheatLotteryStrategyResult(false);
    }

    private Long doMatchProcess(LotteryConsumerParams consumer, LotteryOrderParams order, LotteryRequestParams request) {
        AnticheatLotteryDebugLogEntity debug = new AnticheatLotteryDebugLogEntity();
        debug.setStrategyType(AnticheatLotteryStrategyConfigEntity.TYPE_WHITE_IP);
        debug.setConsumerId(consumer.getConsumerId());
        debug.setPartnerUserId(consumer.getPartnerUserId());
        debug.setIp(request.getIp());
        debug.setLotteryOrderId(order.getLotteryOrderId());
        debug.setRelationId(order.getDuibaActivityId());
        debug.setRelationType(order.getType().value());
        debug.setOperatingActivityId(order.getOperatingActivityId());
        debug.setAppId(order.getAppId());
        debug.setMessage(String.format("此 IP(%s) 在 ip 白名单 ", request.getIp()));
        anticheatLotteryDebugLogDao.insert(debug);

        return debug.getId();
    }
}
