package cn.com.duiba.anticheat.center.biz.strategy.goods.impl;

import cn.com.duiba.anticheat.center.api.domain.goods.BehaviorParams;
import cn.com.duiba.anticheat.center.api.domain.goods.ConsumerParams;
import cn.com.duiba.anticheat.center.api.domain.goods.GoodsParams;
import cn.com.duiba.anticheat.center.api.domain.goods.RequestParams;
import cn.com.duiba.anticheat.center.biz.dao.goods.AnticheatDebugLogDao;
import cn.com.duiba.anticheat.center.biz.entity.goods.AnticheatDebugLogEntity;
import cn.com.duiba.anticheat.center.biz.entity.goods.AnticheatStrategyAppConfigEntity;
import cn.com.duiba.anticheat.center.biz.entity.goods.AnticheatStrategyConfigEntity;
import cn.com.duiba.anticheat.center.biz.strategy.goods.AnticheatStrategy;
import cn.com.duiba.anticheat.center.common.tool.RedisProtectTool;
import cn.com.duiba.wolf.cache.AdvancedCacheClient;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

import javax.annotation.Resource;
import java.util.*;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.TimeUnit;

/**
 * 同用户积分连续兑换
 * <p/>
 * App：疯狂锁屏，云图TV，Wifi伴侣
 * <p/>
 * 判断规则： 进积分商城到兑换，时间小于2分钟
 * 最近4笔兑换，UA相同，且用户积分相同，且兑换同一个商品
 * 拒绝规则： 进积分商城到兑换，时间小于2分钟 且 用户积分=xx 且商品id=xx
 * <p/>
 * 生效时长： 2小时
 *
 * @author xuhengfei
 */
@Component
public class AnticheatSameCreditsStrategy implements AnticheatStrategy {

    @Autowired
    private AnticheatStrategyConfigService anticheatStrategyConfigService;
    @Autowired
    private AnticheatDebugLogDao anticheatDebugLogDao;
    @Resource(name = "redisTemplate")
    private AdvancedCacheClient advancedCacheClient;

    private static final int RANGE_VALUE = 20;    // 匹配范围

    private static final int MATCH_VALUE = 4;    // 匹配值

    @Override
    public boolean isEnable() {
        return anticheatStrategyConfigService.getCacheConfig(AnticheatStrategyConfigEntity.TYPE_SAME_CREDITS).getEnable();
    }

    @Override
    public int getCheckMode() {
        return anticheatStrategyConfigService.getCacheConfig(AnticheatStrategyConfigEntity.TYPE_SAME_CREDITS).getCheckMode();
    }

    @Override
    public boolean isBlackMode() {
        return true;
    }

    @Override
    public boolean isAppEnable(Long appId) {
        Map<Long, AnticheatStrategyAppConfigEntity> map = anticheatStrategyConfigService.getCacheAppConfig(AnticheatStrategyConfigEntity.TYPE_SAME_CREDITS);
        return map.containsKey(appId);
    }

    @Override
    public int getEffectMode() {
        return anticheatStrategyConfigService.getCacheConfig(AnticheatStrategyConfigEntity.TYPE_SAME_CREDITS).getEffectMode();
    }

    @Override
    public AnticheatStrategyResult checkCouponExchange(ConsumerParams consumer, GoodsParams goods, RequestParams request, BehaviorParams behavior) {
        if (consumer.getLastLogin() != null && (new Date().getTime() - consumer.getLastLogin().getTime() > 2 * 60 * 1000L)) {
            // 不是两分钟内下单的
            return new AnticheatStrategyResult(false);
        }

        String key = check(consumer, goods, request);
        if (key != null) {
            putBlackList(key, 2 * 60 * 60);
        }

        if (isInBlackList(consumer.getAppId(), goods.getGtype(), goods.getGid(), consumer.getCredits())) {
            Long debugId = doMatchProcess(consumer, goods, request);
            return new AnticheatStrategyResult(true, debugId);
        }

        return new AnticheatStrategyResult(false);
    }

    /**
     * 为了单元测试，使用了publick
     *
     * @param consumer
     * @param goods
     * @param request
     * @param behavior
     * @return
     */
    public String check(ConsumerParams consumer, GoodsParams goods, RequestParams request) {
        Model model = new Model();
        model.appId = consumer.getAppId();
        model.credits = consumer.getCredits();
        model.consumerId = consumer.getConsumerId();
        model.ua = request.getUserAgent();
        model.gtype = goods.getGtype();
        model.gid = goods.getGid();

        String datakey = getDataKey(model.appId, model.gtype, model.gid);
        Queue<Model> queue = data.computeIfAbsent(datakey, key -> new LinkedBlockingQueue<>());
        queue.offer(model);

        while (queue.size() > RANGE_VALUE) {
            queue.poll();
        }

        int count = 0;
        for (Iterator<Model> it = queue.iterator(); it.hasNext(); ) {
            if (it.next().equalsTo(model)) {
                count++;
            }
        }
        if (count > MATCH_VALUE) {
            return getKey(model.appId, model.gtype, model.gid, model.credits);
        }
        return null;
    }

    private Long doMatchProcess(ConsumerParams consumer, GoodsParams goods, RequestParams request) {
        AnticheatDebugLogEntity debug = new AnticheatDebugLogEntity(true);
        debug.setAppId(consumer.getAppId());
        debug.setItemId(null);
        debug.setAppItemId(null);
        debug.setGtype(goods.getGtype());
        debug.setGid(goods.getGid());
        debug.setConsumerId(consumer.getConsumerId());
        debug.setPartnerUserId(consumer.getPartnerUserId());
        debug.setIp(request.getIp());
        debug.setStrategyType(AnticheatStrategyConfigEntity.TYPE_SAME_CREDITS);
        debug.setMessage("相同积分(" + consumer.getCredits() + ")");

        anticheatDebugLogDao.insert(debug);

        return debug.getId();
    }

    private Map<String, Queue<Model>> data = new HashMap<>();

    private class Model {
        private Long appId;
        private Integer gtype;
        private Long gid;
        private Long credits;
        private Long consumerId;
        private String ua;

        public boolean equalsTo(Model obj) {
            boolean ret = false;
            if (obj.appId.equals(appId) && obj.gtype.equals(gtype) && obj.gid.equals(gid)
                    && obj.credits.equals(credits)) {
                ret = true;
            }
            if(consumerId != null) {
                ret = ret && consumerId.equals(obj.consumerId);
            }
            return ret && obj.ua != null && obj.ua.equals(ua);
        }
    }

    private boolean isInBlackList(Long appId, Integer gtype, Long gid, Long credits) {
        String key = getKey(appId, gtype, gid, credits);
        Object o = RedisProtectTool.getFromCache(advancedCacheClient, key);
        return o != null;
    }

    private void putBlackList(String key, int seconds) {
        advancedCacheClient.set(key, 1, seconds, TimeUnit.SECONDS);
    }

    private String getDataKey(Long appId, Integer gtype, Long gid) {
        return String.format("%s-%s-%s", appId, gtype, gid);
    }

    private String getKey(Long appId, Integer gtype, Long gid, Long credits) {
        return String.format("%s-%s-%s-%s", appId, gtype, gid, credits);
    }

}
