package cn.com.duiba.anticheat.center.biz.utils;

import com.alibaba.fastjson.JSONObject;

import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

import java.text.SimpleDateFormat;
import java.util.Date;

import cn.com.duiba.anticheat.center.api.model.DuibaActivityModel;
import cn.com.duiba.anticheat.center.api.model.DuibaBaseModel;
import cn.com.duiba.boot.perftest.PerfTestContext;

/**
 * 统一内部日志<br>
 *
 * @see <a>http://cf.dui88.com:8090/pages/viewpage.action?pageId=4494009</a>
 *
 */
public final class InnerLog {
    private static final Logger log = LoggerFactory.getLogger("innerLog");
    private static final ThreadLocal<SimpleDateFormat> localDateFormat = new ThreadLocal<SimpleDateFormat>() {
        @Override
        protected SimpleDateFormat initialValue() {
            return new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
        }
    };

    private InnerLog() {
    }


    public static void hitRule(String ruleName, String data,DuibaBaseModel model) {
        if(!PerfTestContext.isCurrentInPerfTestMode()){
            JSONObject jsonLog = new JSONObject();
            jsonLog.put("group", 2);
            jsonLog.put("type", 50);
            jsonLog.put("time", localDateFormat.get().format(new Date()));
            jsonLog.put("dpm", null);
            jsonLog.put("dcm", null);
            JSONObject json = new JSONObject();
            json.put("rule", ruleName);
            json.put("data", data);
            if(model!=null) {
                json.put("consumerId", model.getConsumerId());
                json.put("appId", model.getAppId());
                if(model instanceof DuibaActivityModel) {
                    json.put("activityId", ((DuibaActivityModel)model).getActivityId());
                }

            }
            jsonLog.put("json", json);
            if (log.isInfoEnabled()) {
                log.info(jsonLog.toJSONString());
            }
        }
    }

}
