CREATE TABLE `ResourceInstance`
(
  `Id`             bigint unsigned NOT NULL AUTO_INCREMENT COMMENT '主键',
  `Type`           varchar(60)     NOT NULL DEFAULT 'mysql' COMMENT '资源类型',
  `TypeId`         bigint          NOT NULL COMMENT '资源类型',
  `Cluster`        varchar(60)     NOT NULL DEFAULT 'default' COMMENT '资源实例的集群',
  `InstanceName`   varchar(60)     NOT NULL COMMENT '实例名称',
  `InstanceKey`    varchar(60)     NOT NULL COMMENT '实例别名',
  `OrganizationId` bigint unsigned NOT NULL DEFAULT 1 COMMENT '业务线id',
  `Description`    varchar(500)    NULL     DEFAULT '' COMMENT '描述',
  `GmtCreate`      timestamp       NOT NULL DEFAULT CURRENT_TIMESTAMP COMMENT '创建时间',
  `GmtModified`    timestamp       NOT NULL DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP COMMENT '最后修改时间',
  `NeedAuthStatus` tinyint(4) unsigned NOT NULL DEFAULT 1 COMMENT '实例是否需要审核 0-否 1-是',
  PRIMARY KEY (`Id`),
  UNIQUE KEY `UK_Instance` (`Cluster`, `Type`, `InstanceKey`),
  KEY `GmtModified` (`GmtModified`),
  KEY `OrganizationId` (`OrganizationId`)
) ENGINE = InnoDB
  DEFAULT CHARSET = utf8mb4 COMMENT ='资源实例';

CREATE TABLE `ResourceInstanceItem`
(
    `Id`          bigint unsigned NOT NULL AUTO_INCREMENT COMMENT '主键',
    `InstanceId`  bigint unsigned NOT NULL COMMENT '资源实例Id',
    `TypeKey`     varchar(64)     NOT NULL COMMENT '实例类型',
    `FieldKey`    varchar(128)    NOT NULL COMMENT '键名',
    `Value`       longtext        NOT NULL COMMENT '配置项值',
    `Operator`    bigint unsigned NOT NULL COMMENT '最后的操作者',
    `GmtCreate`   timestamp       NOT NULL DEFAULT CURRENT_TIMESTAMP COMMENT '创建时间',
    `GmtModified` timestamp       NOT NULL DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP COMMENT '最后修改时间',
    PRIMARY KEY (`Id`),
    UNIQUE KEY `UK_ResourceItemKey` (`FieldKey`,`InstanceId`),
    KEY `GmtModified` (`GmtModified`),
    KEY `IX_FieldKey` (`TypeKey`,`FieldKey`)
) ENGINE = InnoDB DEFAULT CHARSET = utf8mb4 COMMENT ='资源实例配置';


CREATE TABLE `ResourceType`
(
  `Id`          bigint unsigned NOT NULL AUTO_INCREMENT COMMENT '主键',
  `Name`        varchar(64)     NOT NULL COMMENT '资源类型名称',
  `TypeKey`     varchar(64)     NOT NULL COMMENT '资源类型别名',
  `Description` varchar(500)    NULL     DEFAULT '' COMMENT '描述',
  `GmtCreate`   timestamp       NOT NULL DEFAULT CURRENT_TIMESTAMP COMMENT '创建时间',
  `GmtModified` timestamp       NOT NULL DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP COMMENT '最后修改时间',
  PRIMARY KEY (`Id`),
  UNIQUE KEY `UK_ResourceTypeKey` (`TypeKey`),
  KEY `GmtModified` (`GmtModified`)
) ENGINE = InnoDB
  DEFAULT CHARSET = utf8mb4 COMMENT ='资源类型';


CREATE TABLE `ResourceTypeSchema`
(
  `Id`          bigint unsigned NOT NULL AUTO_INCREMENT COMMENT '主键',
  `TypeId`      bigint unsigned NOT NULL COMMENT '资源类型Id',
  `FieldKey`    varchar(128)    NOT NULL COMMENT '实例配置字段名称',
  `IsPassword`  bit(1)          NOT NULL DEFAULT b'0' COMMENT '1: 密码, 0: normal',
  `IndexValue`  bit(1)          NOT NULL DEFAULT b'0' COMMENT '是否是索引字段，索引字段可以成为资源定位的检索条件',
  `Description` varchar(500)    NULL     DEFAULT '' COMMENT '描述',
  `GmtCreate`   timestamp       NOT NULL DEFAULT CURRENT_TIMESTAMP COMMENT '创建时间',
  `GmtModified` timestamp       NOT NULL DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP COMMENT '最后修改时间',
  PRIMARY KEY (`Id`),
  UNIQUE KEY `UK_ResourceTypeSchema` (`TypeId`, `FieldKey`),
  KEY `GmtModified` (`GmtModified`)
) ENGINE = InnoDB
  DEFAULT CHARSET = utf8mb4 COMMENT ='资源类型Schema';


CREATE TABLE `ResourceTypeTag`
(
  `Id`          bigint unsigned NOT NULL AUTO_INCREMENT COMMENT '主键',
  `TypeId`      bigint unsigned NOT NULL COMMENT '资源类型Id',
  `TagKey`      varchar(64)     NOT NULL DEFAULT 'default' COMMENT '标签别名',
  `TagName`     varchar(64)     NOT NULL DEFAULT 'default' COMMENT '标签名称',
  `GmtCreate`   timestamp       NOT NULL DEFAULT CURRENT_TIMESTAMP COMMENT '创建时间',
  `GmtModified` timestamp       NOT NULL DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP COMMENT '最后修改时间',
  PRIMARY KEY (`Id`),
  UNIQUE KEY `UK_ResourceTypeTag` (`TypeId`, `TagKey`),
  KEY `GmtModified` (`GmtModified`)
) ENGINE = InnoDB
  DEFAULT CHARSET = utf8mb4 COMMENT ='资源类型Tag';


CREATE TABLE `ResourceUser`
(
  `Id`          bigint unsigned NOT NULL AUTO_INCREMENT COMMENT '主键',
  `Name`        varchar(64)     NOT NULL COMMENT '用户名称',
  `GmtCreate`   timestamp       NOT NULL DEFAULT CURRENT_TIMESTAMP COMMENT '创建时间',
  `GmtModified` timestamp       NOT NULL DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP COMMENT '最后修改时间',
  PRIMARY KEY (`Id`),
  KEY `GmtModified` (`GmtModified`)
) ENGINE = InnoDB
  DEFAULT CHARSET = utf8mb4 COMMENT ='资源化配置的客户端账号';

CREATE TABLE `ResourceUserKey`
(
  `Id`             bigint unsigned NOT NULL AUTO_INCREMENT COMMENT '主键',
  `UserId`         bigint unsigned NOT NULL COMMENT '用户id',
  `ExpirationTime` datetime        NULL COMMENT '有效期，null表示永久',
  `AccessKey`      varchar(128)    NOT NULL COMMENT '用户Key',
  `AccessSecret`   varchar(128)    NOT NULL COMMENT '用户秘钥',
  `GmtCreate`      timestamp       NOT NULL DEFAULT CURRENT_TIMESTAMP COMMENT '创建时间',
  `GmtModified`    timestamp       NOT NULL DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP COMMENT '最后修改时间',
  PRIMARY KEY (`Id`),
  KEY `IX_UserId` (`UserId`),
  UNIQUE KEY `UK_AccessKey` (`AccessKey`),
  KEY `GmtModified` (`GmtModified`)
) ENGINE = InnoDB
  DEFAULT CHARSET = utf8mb4 COMMENT ='资源化配置账号秘钥';

CREATE TABLE `UserAccessToken`
(
  `Id`          bigint unsigned NOT NULL AUTO_INCREMENT COMMENT '主键',
  `AccessToken` varchar(128)    NOT NULL COMMENT '访问验证码',
  `KeyId`       bigint unsigned NOT NULL COMMENT 'ResourceUserKey的id',
  `UserId`      bigint unsigned NOT NULL COMMENT 'ResourceUser的id',
  `Ip`          varchar(128)    NOT NULL COMMENT '发起验证的客户端ip',
  `GmtCreate`   timestamp       NOT NULL DEFAULT CURRENT_TIMESTAMP COMMENT '创建时间',
  `GmtModified` timestamp       NOT NULL DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP COMMENT '最后修改时间',
  PRIMARY KEY (`Id`),
  UNIQUE KEY `UK_AccessToken` (`AccessToken`),
  KEY `UserId` (`UserId`),
  KEY `KeyId` (`KeyId`),
  KEY `GmtCreate` (`GmtCreate`)
) ENGINE = InnoDB
  DEFAULT CHARSET = utf8mb4 COMMENT ='资源化配置账号验证所产生的AccessToken';


CREATE TABLE `ResourceUserOwner`
(
  `Id`          bigint unsigned NOT NULL AUTO_INCREMENT COMMENT '主键',
  `OwnerId`     bigint unsigned NOT NULL COMMENT 'ownerId对应sso的人员主键',
  `UserId`      bigint unsigned NOT NULL COMMENT 'ResourceUser的id',
  `GmtCreate`   timestamp       NOT NULL DEFAULT CURRENT_TIMESTAMP COMMENT '创建时间',
  `GmtModified` timestamp       NOT NULL DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP COMMENT '最后修改时间',
  PRIMARY KEY (`Id`),
  UNIQUE KEY `UK_UserOwner` (`OwnerId`, `UserId`),
  KEY `GmtModified` (`GmtModified`)
) ENGINE = InnoDB
  DEFAULT CHARSET = utf8mb4 COMMENT ='客户端Owner';


CREATE TABLE `ResourceTemplate`
(
  `Id`          bigint unsigned NOT NULL AUTO_INCREMENT COMMENT '主键',
  `TypeId`      bigint unsigned NOT NULL COMMENT '资源类型Id',
  `Name`        varchar(64)     NOT NULL COMMENT '场景模板名称',
  `Description` varchar(500)    NOT NULL DEFAULT '' COMMENT '描述',
  `GmtCreate`   timestamp       NOT NULL DEFAULT CURRENT_TIMESTAMP COMMENT '创建时间',
  `GmtModified` timestamp       NOT NULL DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP COMMENT '最后修改时间',
  PRIMARY KEY (`Id`),
  KEY `TypeId` (`TypeId`),
  KEY `GmtModified` (`GmtModified`)
) ENGINE = InnoDB
  DEFAULT CHARSET = utf8mb4 COMMENT ='用户配置模板';



CREATE TABLE `ResourceUserItem`
(
  `Id`          bigint unsigned  NOT NULL AUTO_INCREMENT COMMENT '主键',
  `ItemType`    tinyint unsigned NOT NULL COMMENT '1.模板配置，2，引用配置',
  `RefId`       bigint unsigned  NOT NULL COMMENT '对应类型的实体id',
  `ItemKey`     varchar(256)     NOT NULL COMMENT '配置键',
  `ItemValue`   longtext COMMENT '配置值',
  `Comment`     varchar(1024)    NULL     DEFAULT '' COMMENT '备注',
  `Operator`    bigint unsigned  NOT NULL COMMENT '最后的操作者',
  `GmtCreate`   timestamp        NOT NULL DEFAULT CURRENT_TIMESTAMP COMMENT '创建时间',
  `GmtModified` timestamp        NOT NULL DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP COMMENT '最后修改时间',
  PRIMARY KEY (`Id`),
  KEY `TypeRef` (`ItemType`, `RefId`),
  KEY `GmtModified` (`GmtModified`)
) ENGINE = InnoDB
  DEFAULT CHARSET = utf8mb4 COMMENT ='用户配置';


CREATE TABLE `ResourceInstanceReference`
(
  `Id`            bigint unsigned NOT NULL AUTO_INCREMENT COMMENT '主键',
  `Cluster`       varchar(60)     NOT NULL DEFAULT 'default' COMMENT '集群',
  `UserId`        bigint unsigned NOT NULL COMMENT '用户id',
  `InstanceId`    bigint unsigned NOT NULL COMMENT '资源实例Id',
  `InstanceAlias` varchar(80) COMMENT '自定义资源标识，用于覆盖资源实例的原有的标识',
  `BizId`         varchar(80)     NOT NULL COMMENT '实际业务场景标识',
  `TemplateId`    bigint unsigned COMMENT '是否附加模板id',
  `Active`        bit             NOT NULL default 0 COMMENT '是否在使用，为false时，表示未启用，true为使用状态',
  `Operator`      bigint unsigned NOT NULL COMMENT '申请人',
  `Authorization` bit             NOT NULL default 0 COMMENT '是否授权，只有授权的引用才能被启用',
  `GmtCreate`     timestamp       NOT NULL DEFAULT CURRENT_TIMESTAMP COMMENT '创建时间',
  `GmtModified`   timestamp       NOT NULL DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP COMMENT '最后修改时间',
  PRIMARY KEY (`Id`),
  KEY `Reference` (`UserId`, `BizId`, `Cluster`),
  UNIQUE KEY `IxRelation` (`InstanceId`, `UserId`, `BizId`),
  KEY `IxTemplateId` (`TemplateId`)
) ENGINE = InnoDB
  DEFAULT CHARSET = utf8mb4 COMMENT ='用户实例引用表，描述用户和实例之间的关系';


CREATE TABLE `ResourceReferenceRelease`
(
  `Id`                     bigint unsigned NOT NULL AUTO_INCREMENT COMMENT '主键',
  `Name`                   varchar(100)    NOT NULL COMMENT '发布名称',
  `ReferenceId`            bigint unsigned NOT NULL COMMENT '引用id',
  `Operator`               bigint unsigned NOT NULL COMMENT '操作者id',
  `Configurations`         longtext COMMENT '发布的配置快照',
  `InstanceConfigurations` longtext COMMENT '发布的实例配置快照',
  `Abandoned`              bit             NOT NULL default 0 COMMENT '是否被抛弃，一个ReferenceId只会有一个发布是不被抛弃的,代表有效的发布',
  `Comment`                varchar(500)    NOT NULL default '' COMMENT '发布说明',
  `ReleaseKey`             varchar(256)    NOT NULL COMMENT '发布的的唯一编码',
  `GmtCreate`              timestamp       NOT NULL DEFAULT CURRENT_TIMESTAMP COMMENT '创建时间',
  `GmtModified`            timestamp       NOT NULL DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP COMMENT '最后修改时间',
  PRIMARY KEY (`Id`),
  KEY `IsPublish` (`ReferenceId`, `Abandoned`),
  KEY `GmtCreate` (`GmtCreate`)
) ENGINE = InnoDB
  DEFAULT CHARSET = utf8mb4 COMMENT ='用户实例引用表配置发布表';


