package cn.com.duiba.bigdata.common.biz.enums;

/**
 * @author xugf 2020-11-27
 * hologres表的所有字段说明，枚举字段需要与 HologresDimensionEnum 中的枚举字段相同
 */
public enum DuibaExt01LogDetailDayEnum {

    DATE_PARTITION("date_partition", "按天分区，格式：yyyyMMdd"),

    LOG_UUID("log_uuid", "唯一键"),

    UNIX_TIME("unix_time", "unix时间戳"),

    EXT_GROUP("ext_group", "公司业务分类，大类"),

    EXT_TYPE("ext_type", "日志分类，小类"),

    CONSUMER_ID("consumer_id", "用户id"),

    APP_ID("app_id", "媒体id"),

    SLOT_ID("slot_id", "广告位id"),

    ACTIVITY_ID("activity_id", "活动id"),

    IS_DIRECT("is_direct", "1:url包含direct字符串")







    ;


    //hologres 中表定义的字段名称
    private String tableFieldName;

    //字段备注
    private String desc;

    DuibaExt01LogDetailDayEnum(String tableFieldName, String desc) {
        this.tableFieldName = tableFieldName;
        this.desc = desc;
    }

    public String getTableFieldName() {
        return tableFieldName;
    }

    public String getDesc() {
        return desc;
    }
}
