package cn.com.duiba.bigdata.common.biz.enums;

import cn.com.duiba.bigdata.common.biz.constant.HologresTableKeys;
import org.apache.commons.lang3.StringUtils;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

/**
 * @author xugf
 * hologres 表和字段集合，新增一张hologres表，需要在这个类中注册下
 */
public enum HologresTableEnum {
    INSTANCE;

    private Map<String, List<String>> tableFieldMap = new HashMap<>();

    private HologresTableEnum() {

        //兑吧访问日志明细表
        initTableField(HologresTableKeys.DUIBA_ACCESS_LOG_DETAIL_MONTH, DuibaAccessLogDetailMonthEnum.values());

        //兑吧曝光日志明细表
        initTableField(HologresTableKeys.DUIBA_EXPOSURE_LOG_DETAIL_MONTH, DuibaExposureLogDetailMonthEnum.values());

        //兑吧内部日志明细表
        //保存一个月数据
        initTableField(HologresTableKeys.DUIBA_INNER_LOG_DETAIL_MONTH, DuibaInnerLogDetailMonthEnum.values());

        //保存一天数据
        initTableField(HologresTableKeys.DUIBA_INNER_LOG_DETAIL_DAY, DuibaInnerLogDetailDayEnum.values());

        //访问日志天粒度汇总数据
        initTableField(HologresTableKeys.DUIBA_ACCESS_LOG_OFFLINE, DuibaAccessLogOfflineEnum.values());

        //内部日志天粒度汇总数据
        initTableField(HologresTableKeys.DUIBA_INNER_LOG_OFFLINE, DuibaInnerLogOfflineEnum.values());

        //访问日志实验平台数据
        initTableField(HologresTableKeys.LAB_ACCESS_LOG_DETAIL_DAY, LabAccessLogDetailDayEnum.values());

        //内部日志实验平台数据
        initTableField(HologresTableKeys.LAB_INNER_LOG_DETAIL_DAY, LabInnerLogDetailDayEnum.values());

    }

    //初始化hologres表字段
    private void initTableField(String tableName, Enum[] enums) {
        List<String> list = new ArrayList<>();
        for(Enum e : enums) {
            list.add(e.toString());
        }
        tableFieldMap.put(tableName, list);
    }

    /**
     * 检查hologres 表中是否存在指定的字段
     *
     * @param tableName hologres表名
     * @param fieldName 表中的字段
     * @return true:存在 false:不存在
     */
    public boolean exist(String tableName, String fieldName) {
        //参数校验
        if (StringUtils.isAnyBlank(tableName, fieldName)) {
            return false;
        }

        if (tableFieldMap.get(tableName) == null) {
            return false;
        }

        return tableFieldMap.get(tableName).contains(fieldName);
    }

}
