package cn.com.duiba.bigdata.common.biz.enums;

/**
 * @author xugf 2020-11-27
 * hologres表的所有字段说明，枚举字段需要与 HologresDimensionEnum 中的枚举字段相同
 */
public enum LabAccessLogDetailDayEnum {

    DATE_PARTITION("date_partition", "按天分区，格式：yyyyMMdd"),

    LOG_UUID("log_uuid", "唯一键"),

    UNIX_TIME("unix_time", "unix时间戳"),

    CONSUMER_ID("consumer_id", "用户id"),

    URL_HOST("url_host", "域名"),

    URL_PATH("url_path", "接口方法，已全部转换成小写"),

    APP_ID("app_id", "媒体id"),

    SLOT_ID("slot_id", "广告位id"),

    DPM_B("dpm_b", "埋点"),

    //测试平台实验组id
    TEST_GROUP_ID("test_group_id", "测试平台实验组id"),

    //测试平台测试层编码
    TEST_LAYER_CODE("test_layer_code", "测试平台测试层编码"),

    //测试平台实验计划ID
    TEST_PLAN_ID("test_plan_id", "测试平台实验计划ID")


    ;



    //hologres 中表定义的字段名称
    private String tableFieldName;

    //字段备注
    private String desc;

    LabAccessLogDetailDayEnum(String tableFieldName, String desc) {
        this.tableFieldName = tableFieldName;
        this.desc = desc;
    }

    public String getTableFieldName() {
        return tableFieldName;
    }

    public String getDesc() {
        return desc;
    }
}
