package cn.com.duiba.bigdata.common.biz.enums;

/**
 * @author xugf 2020-11-27
 * hologres表的所有字段说明，枚举字段需要与 HologresDimensionEnum 中的枚举字段相同
 */
public enum LabInnerLogDetailDayEnum {

    DATE_PARTITION("date_partition", "按天分区，格式：yyyyMMdd"),

    LOG_UUID("log_uuid", "唯一键"),

    UNIX_TIME("unix_time", "unix时间戳"),

    INNER_GROUP("inner_group", "公司业务分类，大类"),

    INNER_TYPE("inner_type", "日志分类，小类"),

    APP_ID("app_id", "媒体id"),

    SLOT_ID("slot_id", "广告位id"),

    ADVERT_TYPE("advert_type", "广告类型（推啊 -1-互动式广告，4-展示广告，6-激励广告）"),

    IS_FREE("is_free", "是否免费 (0:收费 1:免费)"),

    RISK_TYPE("risk_type", "风控类型 0：正常，1：用户作弊，2：广告位作弊"),

    //测试平台实验组id
    TEST_GROUP_ID("test_group_id", "测试平台实验组id"),

    //测试平台测试层编码
    TEST_LAYER_CODE("test_layer_code", "测试平台测试层编码"),

    //测试平台实验计划ID
    TEST_PLAN_ID("test_plan_id", "测试平台实验计划ID");


    //hologres 中表定义的字段名称
    private String tableFieldName;

    //字段备注
    private String desc;

    LabInnerLogDetailDayEnum(String tableFieldName, String desc) {
        this.tableFieldName = tableFieldName;
        this.desc = desc;
    }

    public String getTableFieldName() {
        return tableFieldName;
    }

    public String getDesc() {
        return desc;
    }
}
