/*
 * Decompiled with CFR 0.152.
 */
package cn.com.duiba.bigdata.common.biz.utils;

import com.alibaba.fastjson.JSON;
import com.google.common.base.CaseFormat;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang3.StringUtils;
import org.apache.hadoop.hbase.Cell;
import org.apache.hadoop.hbase.CellUtil;
import org.apache.hadoop.hbase.client.Result;
import org.apache.hadoop.hbase.util.Bytes;
import org.apache.hadoop.hbase.util.CollectionUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class HbaseResultUtil {
    private static final Logger logger = LoggerFactory.getLogger(HbaseResultUtil.class);

    public static String getLowerCamelColumn(boolean lowerCamel, String column) {
        if (lowerCamel && column.contains("_")) {
            return CaseFormat.LOWER_UNDERSCORE.to(CaseFormat.LOWER_CAMEL, column);
        }
        return column;
    }

    public static void putMapData(Map<String, String> map, String column, String value, boolean lowerCamel) {
        if (StringUtils.isAnyBlank((CharSequence[])new CharSequence[]{column, value})) {
            return;
        }
        column = HbaseResultUtil.getLowerCamelColumn(lowerCamel, column);
        map.put(column, value);
    }

    public static void putMapData(Map<String, Map<String, String>> map, String rowKey, Map<String, String> columnMap) {
        if (StringUtils.isBlank((CharSequence)rowKey)) {
            return;
        }
        if (columnMap == null || columnMap.size() == 0) {
            return;
        }
        map.put(rowKey, columnMap);
    }

    public static String getResultString(Result result, String family, String column) {
        String value = "";
        if (result != null && result.containsColumn(family.getBytes(), column.getBytes())) {
            value = Bytes.toString((byte[])result.getValue(family.getBytes(), column.getBytes()));
        }
        return value;
    }

    public static Map<String, String> getResultMap(Result result, String family, List<String> columns) {
        return HbaseResultUtil.getResultMap(result, family, columns, false);
    }

    public static Map<String, String> getResultMap(Result result, String family, List<String> columns, boolean lowerCamel) {
        HashMap<String, String> map = new HashMap<String, String>();
        for (String column : columns) {
            String value = HbaseResultUtil.getResultString(result, family, column);
            HbaseResultUtil.putMapData(map, column, value, lowerCamel);
        }
        return map;
    }

    public static <T> T getResultMap(Result result, String family, List<String> columns, Class<T> clazz) {
        Map<String, String> map = HbaseResultUtil.getResultMap(result, family, columns, true);
        return (T)JSON.parseObject((String)JSON.toJSONString(map), clazz);
    }

    public static Map<String, String> getResultMap(Result result, String family) {
        return HbaseResultUtil.getResultMap(result, family, false);
    }

    public static Map<String, String> getResultMap(Result result, String family, boolean lowerCamel) {
        if (result == null || result.isEmpty()) {
            return null;
        }
        List cellList = result.listCells();
        if (CollectionUtils.isEmpty((Collection)cellList)) {
            return null;
        }
        HashMap<String, String> map = new HashMap<String, String>();
        for (Cell cell : cellList) {
            if (!Bytes.toString((byte[])CellUtil.cloneFamily((Cell)cell)).equalsIgnoreCase(family)) continue;
            String column = Bytes.toString((byte[])CellUtil.cloneQualifier((Cell)cell));
            String value = Bytes.toString((byte[])CellUtil.cloneValue((Cell)cell));
            HbaseResultUtil.putMapData(map, column, value, lowerCamel);
        }
        return map;
    }

    public static <T> T getResultMap(Result result, String family, Class<T> clazz) {
        Map<String, String> map = HbaseResultUtil.getResultMap(result, family, true);
        return (T)JSON.parseObject((String)JSON.toJSONString(map), clazz);
    }

    public static Map<String, String> getResultMap(Result[] results, String family, String column) {
        HashMap<String, String> map = new HashMap<String, String>();
        for (Result result : results) {
            if (result == null || result.isEmpty()) continue;
            String rowKey = Bytes.toString((byte[])result.getRow());
            String value = HbaseResultUtil.getResultString(result, family, column);
            if (!StringUtils.isNotBlank((CharSequence)value)) continue;
            map.put(rowKey, value);
        }
        return map;
    }

    public static Map<String, Map<String, String>> getResultMap(Result[] results, String family, List<String> columns) {
        HashMap<String, Map<String, String>> map = new HashMap<String, Map<String, String>>();
        for (Result result : results) {
            if (result == null || result.isEmpty()) continue;
            String rowKey = Bytes.toString((byte[])result.getRow());
            Map<String, String> columnMap = HbaseResultUtil.getResultMap(result, family, columns);
            HbaseResultUtil.putMapData(map, rowKey, columnMap);
        }
        return map;
    }

    public static <T> Map<String, T> getResultMap(Result[] results, String family, List<String> columns, Class<T> clazz) {
        HashMap<String, T> map = new HashMap<String, T>();
        for (Result result : results) {
            if (result == null || result.isEmpty()) continue;
            String rowKey = Bytes.toString((byte[])result.getRow());
            T obj = HbaseResultUtil.getResultMap(result, family, columns, clazz);
            if (obj == null) continue;
            map.put(rowKey, obj);
        }
        return map;
    }

    public static Map<String, Map<String, String>> getResultMap(Result[] results, String family, Map<String, List<String>> rowkeyMap) {
        HashMap<String, Map<String, String>> map = new HashMap<String, Map<String, String>>();
        for (Result result : results) {
            if (result == null || result.isEmpty()) continue;
            String rowKey = Bytes.toString((byte[])result.getRow());
            Map<String, String> columnMap = HbaseResultUtil.getResultMap(result, family, rowkeyMap.get(rowKey));
            HbaseResultUtil.putMapData(map, rowKey, columnMap);
        }
        return map;
    }

    public static <T> Map<String, T> getResultMap(Result[] results, String family, Map<String, List<String>> rowkeyMap, Class<T> clazz) {
        HashMap<String, T> map = new HashMap<String, T>();
        for (Result result : results) {
            String rowKey;
            T obj;
            if (result == null || result.isEmpty() || (obj = HbaseResultUtil.getResultMap(result, family, rowkeyMap.get(rowKey = Bytes.toString((byte[])result.getRow())), clazz)) == null) continue;
            map.put(rowKey, obj);
        }
        return map;
    }

    public static Map<String, Map<String, String>> getResultMap(Result[] results, String family) {
        HashMap<String, Map<String, String>> map = new HashMap<String, Map<String, String>>();
        for (Result result : results) {
            if (result == null || result.isEmpty()) continue;
            String rowKey = Bytes.toString((byte[])result.getRow());
            Map<String, String> columnMap = HbaseResultUtil.getResultMap(result, family);
            HbaseResultUtil.putMapData(map, rowKey, columnMap);
        }
        return map;
    }

    public static <T> Map<String, T> getResultMap(Result[] results, String family, Class<T> clazz) {
        HashMap<String, T> map = new HashMap<String, T>();
        for (Result result : results) {
            if (result == null || result.isEmpty()) continue;
            String rowKey = Bytes.toString((byte[])result.getRow());
            T obj = HbaseResultUtil.getResultMap(result, family, clazz);
            if (obj == null) continue;
            map.put(rowKey, obj);
        }
        return map;
    }
}

