package cn.com.duiba.bigdata.common.biz.enums.tables.bigdata;

/**
 * @author xugf 2020-11-27
 * hologres表的所有字段说明，枚举字段需要与 HologresDimensionEnum 中的枚举字段相同
 */
public enum AdxAlgDetailMinuteMonthEnum {

    DATE_PARTITION("date_partition", "按天分区，格式：yyyyMMdd"),

    DATA_MD5("data_md5", "唯一键"),

    UNIX_TIME("unix_time", "unix时间戳"),

    INNER_GROUP("inner_group", "公司业务分类，大类"),

    INNER_TYPE("inner_type", "日志分类，小类"),

    GROUP_ID("group_id", "ADX推广组id"),

    RESOURCE_ID("resource_id", "ADX资源位id"),

    IDEA_ID("idea_id", "ADX创意id"),

    ADX_DEAL_TYPE("adx_deal_type", "adx竞价类型 0-RTB 1-PD 2-PDB"),

    PRICE_TYPE("price_type", "创意出价方式 0:人工出价 1:算法出价 2:直投出价"),

    ADX_ALG_MODE("adx_alg_mode", "1-互动按roi出价， 2-互动按cpc出价");


    //hologres 中表定义的字段名称
    private final String tableFieldName;

    //字段备注
    private final String desc;

    AdxAlgDetailMinuteMonthEnum(String tableFieldName, String desc) {
        this.tableFieldName = tableFieldName;
        this.desc = desc;
    }

    public String getTableFieldName() {
        return tableFieldName;
    }

    public String getDesc() {
        return desc;
    }
}
