package cn.com.duiba.bigdata.common.biz.enums.tables.duiba_live;

/**
 * @author xugf 2020-05-20
 * hologres表的所有字段说明，枚举字段需要与 HologresDimensionEnum 中的枚举字段相同
 */
public enum DuibaLiveRedPacketLogEnum {

    DATE_PARTITION("date_partition", "按天分区，格式：yyyyMMdd"),

    LOG_UUID("log_uuid", "唯一键"),

    UNIX_TIME("unix_time", "unix时间戳"),

    INNER_GROUP("inner_group", "公司业务分类，大类"),

    INNER_TYPE("inner_type", "日志分类，小类"),

    LIVE_ID("live_id", "直播id"),

    LIVE_VISITOR_ID("live_visitor_id", "直播用户id"),

    RED_PACKET_ID("red_packet_id", "红包id"),

    RECEIVE_AMOUNT("receive_amount", "红包领取金额，单位是分"),

    IS_STANDARD("is_standard", "是否满足收手气王条件 0:表示不满足 1:表示满足")








    ;


    //hologres 中表定义的字段名称
    private final String tableFieldName;

    //字段备注
    private final String desc;

    DuibaLiveRedPacketLogEnum(String tableFieldName, String desc) {
        this.tableFieldName = tableFieldName;
        this.desc = desc;
    }

    public String getTableFieldName() {
        return tableFieldName;
    }

    public String getDesc() {
        return desc;
    }
}
