package cn.com.duiba.bigdata.common.biz.service;

import cn.com.duiba.bigdata.common.biz.constant.BigdataRedisMetricsKeys;
import cn.com.duiba.bigdata.common.biz.entity.redis.BigdataRedisMetricsEntity;
import cn.com.duiba.bigdata.common.biz.utils.BigdataUtil;

import java.util.Map;

public class CommonService {

    /**
     * 获取bigdata_redis指标池中的统计数据
     *
     * @param map redis hashmap
     * @return 统计指标
     */
    public static BigdataRedisMetricsEntity getBigdataRedisMetricsEntity(Map<String, String> map) {
        if (map == null || map.size() == 0) {
            return null;
        }

        BigdataRedisMetricsEntity info = new BigdataRedisMetricsEntity();

        //后端转化指标（广告主回传）
        info.setBackendCntMap(BigdataUtil.getBackendCntMap(map));

        //基础统计指标
        for (Map.Entry<String, String> entry : map.entrySet()) {
            String key = entry.getKey();
            String value = entry.getValue();
            switch (key) {
                case BigdataRedisMetricsKeys.ACTIVITY_REQUEST:
                    info.setActivityRequest(Long.parseLong(value));
                    break;
                case BigdataRedisMetricsKeys.ACTIVITY_JOIN:
                    info.setActivityJoin(Long.parseLong(value));
                    break;
                case BigdataRedisMetricsKeys.LANDPAGE_EXPOSURE:
                    info.setLandpageExposure(Long.parseLong(value));
                    break;
                case BigdataRedisMetricsKeys.LANDPAGE_CLICK:
                    info.setLandpageClick(Long.parseLong(value));
                    break;
                case BigdataRedisMetricsKeys.LAUNCH:
                    info.setLaunch(Long.parseLong(value));
                    break;
                case BigdataRedisMetricsKeys.EFFECT_CLICK:
                    info.setEffectClick(Long.parseLong(value));
                    break;
                case BigdataRedisMetricsKeys.FEE:
                    info.setFee(Long.parseLong(value));
                    break;
                case BigdataRedisMetricsKeys.MIN_FEE:
                    info.setMinFee(Long.parseLong(value));
                    break;
                case BigdataRedisMetricsKeys.CLICK:
                    info.setClick(Long.parseLong(value));
                    break;
                case BigdataRedisMetricsKeys.ADVERT_EXPOSURE:
                    info.setAdvertExposure(Long.parseLong(value));
                    break;
                case BigdataRedisMetricsKeys.SDK_SLOT_EXPOSURE:
                    info.setSdkSlotExposure(Long.parseLong(value));
                    break;
                case BigdataRedisMetricsKeys.SDK_SLOT_CLICK:
                    info.setSdkSlotClick(Long.parseLong(value));
                    break;
                case BigdataRedisMetricsKeys.API_SLOT_EXPOSURE:
                    info.setApiSlotExposure(Long.parseLong(value));
                    break;
                case BigdataRedisMetricsKeys.API_SLOT_CLICK:
                    info.setApiSlotClick(Long.parseLong(value));
                    break;
                case BigdataRedisMetricsKeys.NEZHA_LAUNCH:
                    info.setNezhaLaunch(Long.parseLong(value));
                    break;
                case BigdataRedisMetricsKeys.PRE_CTR:
                    info.setPreCtr(Double.parseDouble(value));
                    break;
                case BigdataRedisMetricsKeys.PRE_CVR:
                    info.setPreCvr(Double.parseDouble(value));
                    break;
                case BigdataRedisMetricsKeys.STAT_CTR:
                    info.setStatCtr(Double.parseDouble(value));
                    break;
                case BigdataRedisMetricsKeys.STAT_CVR:
                    info.setStatCvr(Double.parseDouble(value));
                    break;
                case BigdataRedisMetricsKeys.ADX_FEE:
                    info.setAdxFee(Long.parseLong(value));
                    break;
                case BigdataRedisMetricsKeys.ADX_CLICK:
                    info.setAdxClick(Long.parseLong(value));
                    break;
                case BigdataRedisMetricsKeys.ADX_EXPOSURE:
                    info.setAdxExposure(Long.parseLong(value));
                    break;
                case BigdataRedisMetricsKeys.ADX_BID:
                    info.setAdxBid(Long.parseLong(value));
                    break;
                case BigdataRedisMetricsKeys.ADX_BID_SUCCESS:
                    info.setAdxBidSuccess(Long.parseLong(value));
                    break;
                case BigdataRedisMetricsKeys.BACKEND_CLICK:
                    info.setBackendClick(Long.parseLong(value));
                    break;
                default:
                    break;
            }
        }

        return info;
    }

}
