package cn.com.duiba.bigdata.common.biz.entity.callable;

import cn.com.duiba.bigdata.common.biz.utils.BigdataCatUtil;
import lombok.extern.slf4j.Slf4j;
import org.apache.commons.lang3.StringUtils;

import java.util.concurrent.Callable;
import java.util.concurrent.TimeoutException;

/**
 * callable 任务，捕获异常并打印cat监控
 */
@Slf4j
public class CallableTask implements Callable {

    private Callable callable;

    private String catName;

    public CallableTask(Callable callable, String catName) {
        this.callable = callable;
        this.catName = catName;
    }


    @Override
    public Object call() {

        try {
            callable.call();
        } catch (Exception e) {
            if (e instanceof TimeoutException | e instanceof InterruptedException) {
                if (StringUtils.isNotBlank(catName)) {
                    //cat埋点，用于记录超时情况
                    BigdataCatUtil.logEvent("callableTimeout", catName);
                }
            } else {
                log.error("callable task error = ", e);
            }

        }

        return null;
    }

}
