package cn.com.duiba.bigdata.common.biz.enums.tables.bigdata_offline;

/**
 * @author liujianxue 2021-09-10
 * hologres表的所有字段说明，枚举字段需要与 HologresDimensionEnum 中的枚举字段相同
 */
public enum AdxFilterReasonOfflineEnum {

    DATE_PARTITION("date_partition", "按天分区，格式：yyyyMMdd"),

    DATA_MD5("data_md5", "唯一键"),

    HALF_HOUR("half_hour", "半小时"),

    UNIX_TIME("unix_time", "unix时间戳"),

    APP_ID("app_id", "媒体id"),

    SLOT_ID("resource_id", "资源位id"),

    ADVERT_ID("group_id", "adx推广组id"),

    ORIENTATION_ID("idea_id", "创意id"),

    FILTER_TYPE("adx_filter_type", "过滤原因"),

    ADX_APP_ID("adx_app_id","adx联盟流量app_id")

    ;

    //hologres 中表定义的字段名称
    private final String tableFieldName;

    //字段备注
    private final String desc;

    AdxFilterReasonOfflineEnum(String tableFieldName, String desc) {
        this.tableFieldName = tableFieldName;
        this.desc = desc;
    }

    public String getTableFieldName() {
        return tableFieldName;
    }

    public String getDesc() {
        return desc;
    }
}
