/*
 * Decompiled with CFR 0.152.
 */
package cn.com.duiba.bigdata.common.biz.utils;

import java.io.IOException;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FSDataOutputStream;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.fs.permission.FsPermission;

public class HDFSUtil {
    private FileSystem fs;

    public HDFSUtil() throws IOException {
        ClassLoader loader = HDFSUtil.class.getClassLoader();
        Configuration conf = new Configuration();
        conf.addResource(loader.getResource("duiba-core-site.xml"));
        conf.addResource(loader.getResource("duiba-hdfs-site.xml"));
        conf.set("fs.hdfs.impl", "org.apache.hadoop.hdfs.DistributedFileSystem");
        conf.setBoolean("dfs.support.append", true);
        if (System.getProperties().getProperty("os.name").toLowerCase().contains("windows")) {
            conf.setBoolean("mapreduce.app-submission.cross-platform", true);
        }
        this.fs = FileSystem.get((Configuration)conf);
    }

    public boolean isAlive() {
        return this.fs != null;
    }

    public void close() throws IOException {
        if (this.fs != null) {
            this.fs.close();
            this.fs = null;
        }
    }

    public synchronized boolean mkdirs(String hdfsPath) throws IOException {
        Path path = new Path(hdfsPath);
        return this.fs.exists(path) || this.fs.mkdirs(path);
    }

    public boolean rename(String source, String dest) throws IOException {
        if (this.fs.exists(new Path(dest))) {
            this.fs.delete(new Path(dest), false);
        }
        return this.fs.rename(new Path(source), new Path(dest));
    }

    public long getFileLength(String file) throws IOException {
        long size = 0L;
        Path path = new Path(file);
        if (this.fs.exists(path)) {
            size = this.fs.getFileStatus(path).getLen();
        }
        return size;
    }

    public FSDataOutputStream createOutputStream(String filePath) throws IOException {
        Path path = new Path(filePath);
        FSDataOutputStream fos = this.fs.exists(path) ? this.fs.append(path) : this.fs.create(path);
        this.fs.setPermission(path, new FsPermission(511));
        return fos;
    }
}

