package cn.com.duiba.bigdata.common.biz.enums;

/**
 * @author xugf
 * 数据展示格式
 */
public enum HologresShowTypeEnum {

    ALL(1, "", "", "timeSegment", "直接返回查询时段内的所有数据"),

    HALF_HOUR(2, "to_timestamp(unix_time - unix_time % 1800)", "to_char(timeSegment,'YYYY-MM-DD HH24:MI:SS')", "timeSegment", "按照半小时分段返回查询时段内的数据"),

    HOUR(3, "to_timestamp(unix_time - unix_time % 3600)", "to_char(timeSegment,'YYYY-MM-DD HH24:MI:SS')", "timeSegment", "按照1小时分段返回查询时段内的数据"),

    DAY(4, "date_partition", "substring(cast(to_timestamp(cast(timeSegment as VARCHAR),'yyyyMMdd HH:mm:ss') as VARCHAR), 0, 20)", "timeSegment", "根据表分区查询汇总数据"),

    //3秒
    THREE_SCEND(5, "to_timestamp(unix_time - unix_time % 3)", "to_char(timeSegment,'YYYY-MM-DD HH24:MI:SS')", "timeSegment", "按照3秒分段返回查询时段内的数据"),

    //30秒 thirty
    THIRTY_SCEND(6, "to_timestamp(unix_time - unix_time % 30)", "to_char(timeSegment,'YYYY-MM-DD HH24:MI:SS')", "timeSegment", "按照30秒分段返回查询时段内的数据"),

    //minutes
    ONE_MINUTES(7, "to_timestamp(unix_time - unix_time % 60)", "to_char(timeSegment,'YYYY-MM-DD HH24:MI:SS')", "timeSegment", "按照1分钟分段返回查询时段内的数据");


    //数据展示格式对应的编码
    private final Integer code;

    //需要拼接的sql代码段
    private final String sqlSegment;

    //对时间段进行格式转化
    private final String formatSegment;

    //时间字段的别名
    private final String fieldName;

    //解释说明
    private final String desc;

    HologresShowTypeEnum(Integer code, String sqlSegment, String formatSegment, String fieldName, String desc) {
        this.code = code;
        this.sqlSegment = sqlSegment;
        this.formatSegment = formatSegment;
        this.fieldName = fieldName;
        this.desc = desc;
    }

    public Integer getCode() {
        return code;
    }

    public String getSqlSegment() {
        return sqlSegment;
    }

    public String getFormatSegment() {
        return formatSegment;
    }

    public String getFieldName() {
        return fieldName;
    }

    public String getDesc() {
        return desc;
    }
}
