package cn.com.duiba.bigdata.common.biz.enums.tables;

import cn.com.duiba.bigdata.common.biz.constant.HologresTableKeys;
import cn.com.duiba.bigdata.common.biz.enums.tables.bigdata.*;
import cn.com.duiba.bigdata.common.biz.enums.tables.bigdata_offline.*;
import cn.com.duiba.bigdata.common.biz.enums.tables.duiba_activity.DuibaSaaSLogEnum;
import cn.com.duiba.bigdata.common.biz.enums.tables.duiba_live.*;
import org.apache.commons.lang3.StringUtils;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

/**
 * @author xugf
 * hologres 表和字段集合，新增一张hologres表，需要在这个类中注册下
 */
public enum HologresTableEnum {
    INSTANCE;

    private final Map<String, List<String>> tableFieldMap;

    HologresTableEnum() {
        //初始化
        tableFieldMap = new HashMap<>();

        //--------------------------bigdata实时明细库--------------------------
        //兑吧访问日志明细表
        initTableField(HologresTableKeys.DUIBA_ACCESS_LOG_DETAIL_MONTH, DuibaAccessLogDetailMonthEnum.values());

        //兑吧曝光日志明细表
        initTableField(HologresTableKeys.DUIBA_EXPOSURE_LOG_DETAIL_MONTH, DuibaExposureLogDetailMonthEnum.values());

        //兑吧内部日志明细表
        //保存一个月数据
        initTableField(HologresTableKeys.DUIBA_INNER_LOG_DETAIL_MONTH, DuibaInnerLogDetailMonthEnum.values());

        //保存一天数据
        initTableField(HologresTableKeys.DUIBA_INNER_LOG_DETAIL_DAY, DuibaInnerLogDetailDayEnum.values());

        //访问日志实验平台数据
        initTableField(HologresTableKeys.LAB_ACCESS_LOG_DETAIL_DAY, LabAccessLogDetailDayEnum.values());

        //内部日志实验平台数据
        initTableField(HologresTableKeys.LAB_INNER_LOG_DETAIL_DAY, LabInnerLogDetailDayEnum.values());

        //adx日志实验平台数据
        initTableField(HologresTableKeys.LAB_ADX_LOG_DETAIL_DAY, LabInnerLogDetailDayEnum.values());

        //算法日志保存一个月数据
        initTableField(HologresTableKeys.ALG_LOG_DETAIL_MONTH, AlgLogDetailMonthEnum.values());

        //adx日志保存一个月数据
        initTableField(HologresTableKeys.ADX_LOG_SUM_DAY, AdxLogSumDayEnum.values());

        //adx竞价请求日志分钟聚合
        initTableField(HologresTableKeys.ADX_BID_REQUEST_LOG_MINUTE, AdxBidRequestLogSumMinuteEnum.values());

        //adx全链路预估指标聚合
        initTableField(HologresTableKeys.ADX_ALG_DETAIL_MINUTE_MONTH, AdxAlgDetailMinuteMonthEnum.values());

        //兑吧活动点击埋点日志
        initTableField(HologresTableKeys.DUIBA_CLICK_LOG_DETAIL_MONTH,DuibaClickLogDetailMonthEnum.values());

        //dmp上传人群包
        initTableField(HologresTableKeys.DMP_UPLOAD_CROWD,DmpUploadCrowdEnum.values());


        //--------------------------bigdata_offline离线汇总回流库--------------------------
        //访问日志天粒度汇总数据
        initTableField(HologresTableKeys.DUIBA_ACCESS_LOG_OFFLINE, DuibaAccessLogOfflineEnum.values());

        //内部日志天粒度汇总数据
        initTableField(HologresTableKeys.DUIBA_INNER_LOG_OFFLINE, DuibaInnerLogOfflineEnum.values());

        //竞价日志半小时粒度窗口函数汇总数据
        initTableField(HologresTableKeys.TUIA_ADVERT_BID_OFFLINE, TuiaAdvertBidOfflineEnum.values());

        //过滤日志半小时粒度窗口函数汇总数据
        initTableField(HologresTableKeys.ADVERT_FILTER_REASON_OFFLINE, AdvertFilterReasonOfflineEnum.values());

        //adx过滤日志半小时粒度窗口函数汇总数据
        initTableField(HologresTableKeys.ADX_FILTER_REASON_OFFLINE, AdxFilterReasonOfflineEnum.values());

        //广告配置过滤日志半小时粒度窗口函数汇总数据
        initTableField(HologresTableKeys.ADVERT_FILTER_CONFIG_OFFLINE, AdvertFilterConfigOfflineEnum.values());

        //媒体线流量指标统计增量表
        initTableField(HologresTableKeys.TB_APP_LINE_DI, TbAppLineDiEnum.values());

        //--------------------------duiba_live兑吧直播库--------------------------
        //兑吧直播-邀请预约到场日志
        initTableField(HologresTableKeys.DUIBA_LIVE_INVITATION_LOG, DuibaLiveInvitationLogEnum.values());

        //兑吧直播-观看互动日志
        initTableField(HologresTableKeys.DUIBA_LIVE_WATCH_LOG, DuibaLiveWatchLogEnum.values());

        //兑吧直播-商品预约点击日志
        initTableField(HologresTableKeys.DUIBA_LIVE_GOODS_APPOINTMENT_LOG, DuibaLiveGoodsAppointmentLogEnum.values());

        //兑吧直播-红包领取日志
        initTableField(HologresTableKeys.DUIBA_LIVE_RED_PACKET_LOG, DuibaLiveRedPacketLogEnum.values());

        //兑吧直播-手气王红包助力日志
        initTableField(HologresTableKeys.DUIBA_LIVE_LUCK_RED_PACKET_LOG, DuibaLiveLuckRedPacketLogEnum.values());

        //兑吧直播-分享日志
        initTableField(HologresTableKeys.DUIBA_LIVE_SHARE_LOG, DuibaLiveShareLogEnum.values());

        //兑吧直播-评论日志
        initTableField(HologresTableKeys.DUIBA_LIVE_COMMON_LOG, DuibaLiveCommonLogEnum.values());

        //兑吧直播-点赞日志
        initTableField(HologresTableKeys.DUIBA_LIVE_GIVE_LIKE_LOG, DuibaLiveGiveLikeLogEnum.values());

        //兑吧直播-关注日志
        initTableField(HologresTableKeys.DUIBA_LIVE_ATTENTION_LOG, DuibaLiveAttentionLogEnum.values());

        //兑吧直播-互动商品
        initTableField(HologresTableKeys.DUIBA_LIVE_ITEM_LOG, DuibaLiveItemLogEnum.values());

        //兑吧直播-互动商品-办卡
        initTableField(HologresTableKeys.DUIBA_LIVE_ITEM_CARD_LOG, DuibaLiveItemCardLogEnum.values());

        //--------------------------duiba_activity兑吧活动--------------------------
        initTableField(HologresTableKeys.DUIBA_SAAS_INNER_LOG, DuibaSaaSLogEnum.values());

    }

    //初始化hologres表字段
    private void initTableField(String tableName, Enum[] enums) {
        List<String> list = new ArrayList<>();
        for(Enum e : enums) {
            list.add(e.toString());
        }
        tableFieldMap.put(tableName, list);
    }

    /**
     * 检查hologres 表中是否存在指定的字段
     *
     * @param tableName hologres表名
     * @param fieldName 表中的字段
     * @return true:存在 false:不存在
     */
    public boolean exist(String tableName, String fieldName) {
        //参数校验
        if (StringUtils.isAnyBlank(tableName, fieldName)) {
            return false;
        }

        if (tableFieldMap.get(tableName) == null) {
            return false;
        }

        return tableFieldMap.get(tableName).contains(fieldName);
    }

}
