package cn.com.duiba.bigdata.common.biz.enums.tables.bigdata;

/**
 * @author liujianxue 2021-09-13
 * hologres表的所有字段说明，枚举字段需要与 HologresDimensionEnum 中的枚举字段相同
 */
public enum DuibaClickLogDetailMonthEnum {

    DATE_PARTITION("date_partition", "按天分区，格式：yyyyMMdd"),

    LOG_UUID("log_uuid", "唯一键"),

    UNIX_TIME("unix_time", "unix时间戳"),

    INNER_GROUP("consumer_id", "用户id：appId+device生成"),

    APP_ID("app_id", "媒体id"),

    APP_SOURCE("app_source", "来源 0：兑吧 1：推啊"),

    DEVELOPER_ID("developer_id", "开发者id"),

    DPM_A("dpm_a", "dpm_a"),

    DPM_B("dpm_b", "dpm_b"),

    DPM_C("dpm_c", "dpm_c"),

    DPM_D("dpm_d", "dpm_d"),

    DCM_A("dcm_a", "dcm_a"),

    DCM_B("dcm_b", "dcm_b"),

    DCM_C("dcm_c", "dcm_c"),

    DCM_D("dcm_d", "dcm_d"),

    DOM_A("dom_a", "dom_a"),

    DOM_B("dom_b", "dom_b"),

    DOM_C("dom_c", "dom_c"),

    DOM_D("dom_d", "dom_d"),



    ;


    //hologres 中表定义的字段名称
    private final String tableFieldName;

    //字段备注
    private final String desc;

    DuibaClickLogDetailMonthEnum(String tableFieldName, String desc) {
        this.tableFieldName = tableFieldName;
        this.desc = desc;
    }

    public String getTableFieldName() {
        return tableFieldName;
    }

    public String getDesc() {
        return desc;
    }
}
