package cn.com.duiba.bigdata.common.biz.enums.tables.bigdata_offline;

/**
 * @author xugf 2020-11-27
 * hologres表的所有字段说明，枚举字段需要与 HologresDimensionEnum 中的枚举字段相同
 * dmp上传人群包
 */
public enum DmpUploadCrowdEnum {

    DATE_PARTITION("date_partition", "按天分区，格式：yyyyMMdd"),

    UNIX_TIME("unix_time", "unix时间戳"),

    DEVICE_ID("device_id", "设备号id"),

    CROWD_IDS("crowd_ids", "人群包id列表，逗号分隔")



    ;


    //hologres 中表定义的字段名称
    private final String tableFieldName;

    //字段备注
    private final String desc;

    DmpUploadCrowdEnum(String tableFieldName, String desc) {
        this.tableFieldName = tableFieldName;
        this.desc = desc;
    }

    public String getTableFieldName() {
        return tableFieldName;
    }

    public String getDesc() {
        return desc;
    }
}
