package cn.com.duiba.bigdata.common.biz.enums.tables.bigdata_offline;

/**
 * @author xugf 2020-11-27
 * hologres表的所有字段说明，枚举字段需要与 HologresDimensionEnum 中的枚举字段相同
 */
public enum TbAppLineDiEnum {

    DATE_PARTITION("date_partition", "按天分区，格式：yyyyMMdd"),

    DATA_MD5("data_md5", "唯一键"),

    HALF_HOUR("half_hour", "半小时"),

    UNIX_TIME("unix_time", "unix时间戳"),

    APP_ID("app_id", "媒体id"),

    SLOT_ID("slot_id", "广告位id"),


    ;

    //hologres 中表定义的字段名称
    private final String tableFieldName;

    //字段备注
    private final String desc;

    TbAppLineDiEnum(String tableFieldName, String desc) {
        this.tableFieldName = tableFieldName;
        this.desc = desc;
    }

    public String getTableFieldName() {
        return tableFieldName;
    }

    public String getDesc() {
        return desc;
    }
}
