/*
 * Decompiled with CFR 0.152.
 */
package cn.com.duiba.bigdata.common.biz.utils;

import java.util.Properties;
import java.util.concurrent.atomic.AtomicInteger;
import org.apache.kafka.clients.producer.KafkaProducer;
import org.apache.kafka.clients.producer.Producer;
import org.apache.kafka.clients.producer.ProducerRecord;

public class KafkaProducerUtil {
    private Producer<String, String> producer = null;
    private AtomicInteger refCount = new AtomicInteger();

    public KafkaProducerUtil(String bootstrapServers) {
        Properties properties = this.getProperties(bootstrapServers);
        this.producer = new KafkaProducer(properties);
    }

    public void increment() {
        this.refCount.incrementAndGet();
    }

    private int decrement() {
        return this.refCount.decrementAndGet();
    }

    public boolean isAlive() {
        return this.producer != null;
    }

    public void sendMessage(String topic, String message) {
        this.producer.send(new ProducerRecord(topic, (Object)message));
    }

    public void flush() {
        this.producer.flush();
    }

    public void close() {
        int count = this.decrement();
        if (count <= 0 && this.producer != null) {
            this.producer.close();
            this.producer = null;
        }
    }

    private Properties getProperties(String bootstrapServers) {
        Properties props = new Properties();
        props.put("bootstrap.servers", bootstrapServers);
        props.put("acks", "1");
        props.put("linger.ms", (Object)100);
        props.put("batch.size", (Object)65536);
        props.put("compression.type", "gzip");
        props.put("retries", (Object)10);
        props.put("retry.backoff.ms", (Object)500);
        props.put("key.serializer", "org.apache.kafka.common.serialization.StringSerializer");
        props.put("value.serializer", "org.apache.kafka.common.serialization.StringSerializer");
        return props;
    }
}

