package cn.com.duiba.bigdata.common.biz.dto;

import cn.com.duiba.bigdata.common.biz.utils.BigdataUtil;
import lombok.Data;

import java.io.Serializable;

/**
 * @author zhuhongxiang
 * Hologres 返回结果转化的对象
 * 定制兑吧-积分商城活动
 */
@Data
public class DuibaIntegralMallDto implements Serializable {

    private static final long serialVersionUID = 4781032718842065380L;

    //维度
    //统计时间段 格式(yyyy-MM-dd HH:mm:ss)
    private String timeSegment;

    //维度
    //媒体id
    private String appId;

    //活动类型
    private String activityType;

    //积分商城-整体概述-活跃度表现
    //总访问pv
    private Long integralVisitPv;

    //总访问uv
    private Long integralVisitUv;

    //下单
    private Long orderNum;

    //下单uv
    private Long orderNumUv;

    //下单成功uv
    private Long finishOrderNumUv;

    //子活动
    private String activityId;

    ;


    //活跃用户占比 下单 / 总访问uv
    public Double getActiveUserProportion() {
        return Double.valueOf(BigdataUtil.division(orderNumUv, integralVisitUv, 4));
    }

    ;

    //人均访问页面 访问pv / 访问uv
    public Double getPagePerVisit() {
        return Double.valueOf(BigdataUtil.division(integralVisitPv, integralVisitUv, 4));
    }

    ;

    //整体概述-积分消耗数据表现

    //总订单量
    private Long mainOrderPv;

    //总兑换人数
    private Long mainOrderUv;

    //订单转化率  总兑换人数 / 商品详情访问uv
    public Double getOrderTransferRate() {
        return Double.valueOf(BigdataUtil.division(mainOrderUv, goodsDetailVisitUv, 4));
    }

    ;

    //成功下单
    private Long finishOrderNum;

    //总积分消耗uv
    private Long totalFeeUv;

    //活动参与率  活动参与uv / 总访问uv
    public Double getActivityJoinDate() {
        return Double.valueOf(BigdataUtil.division(integralActivityJoinUv, integralActivityVisitUv, 4));
    }

    ;

    //活跃情况
    //活跃用户占比 下单 / 总访问uv getActiveUserProrortion()

    //商品兑换转化  （成功下单Uv）/ 总访问uv
    public Double getGoodsCashConversion() {
        return Double.valueOf(BigdataUtil.division(mainOrderUv, integralVisitUv, 4));
    }

    ;

    //活动活跃占比 活动参与人数 / 总访问uv
    public Double getActiveActivityProportion() {
        return Double.valueOf(BigdataUtil.division(integralActivityJoinUv, integralActivityVisitUv, 4));
    }

    ;

    //商品和活动参与都转化的用户占比 成功下单uv  / 总访问uv
    public Double getFinishOrderProportion() {
        return Double.valueOf(BigdataUtil.division(finishOrderNumUv, integralVisitUv, 4));
    }

    ;

    //商品数据情况
    // 商品访问数据
    private Long goodsDetailVisitPv;

    //商品访问数据uv
    private Long goodsDetailVisitUv;

    //活动数据情况
    //活动访问pv
    private Long integralActivityVisitPv;

    //活动参与pv
    private Long integralActivityJoinPv;

    //活动参与人数
    private Long integralActivityJoinUv;

    //活动访问uv
    private Long integralActivityVisitUv;

    //活动复参次数  活动参与pv / 活动参与uv
    public Double getActivityComplexParameter() {
        return Double.valueOf(BigdataUtil.division(integralActivityJoinPv, integralVisitUv, 4));
    }

    ;

    //活动参与率 活动参与uv / 活动访问uv
    public Double getActivityJoinRate() {
        return Double.valueOf(BigdataUtil.division(integralActivityJoinUv, integralActivityVisitUv, 4));
    }

    ;

    //活动访问有效天
    private Long activityVisitEffectDay;

    //活动参与有效天
    private Long activityJoinEffectDay;

    //日均访问pv 访问pv / 有效天数
    public Double getDepotDailyAccessPv() {
        return Double.valueOf(BigdataUtil.division(integralActivityVisitPv, activityVisitEffectDay, 4));
    }

    ;

    //日均访问uv 访问uv / 有效天数
    public Double getDepotDailyAccessUv() {
        return Double.valueOf(BigdataUtil.division(integralActivityVisitUv, activityVisitEffectDay, 4));
    }

    ;

    //日均参与pv 参与pv / 有效天数
    public Double getDepotDailyJoinPv() {
        return Double.valueOf(BigdataUtil.division(integralActivityJoinPv, activityJoinEffectDay, 4));
    }

    ;

    //平均参与uv 参与uv / 访问uv有数据天
    public Double getDepotDailyJoinUv() {
        return Double.valueOf(BigdataUtil.division(integralActivityJoinUv, activityVisitEffectDay, 4));
    }

    ;

    //数据总结
    //消耗积分用户  总积分消耗uv  / 总uv
    public Double getConsumIntegralRate() {
        return Double.valueOf(BigdataUtil.division(totalFeeUv, integralVisitUv, 4));
    }

    ;


}
