package cn.com.duiba.bigdata.common.biz.enums;

import java.util.ArrayList;
import java.util.List;

/**
 * @author xugf
 * hologres 基础指标字段
 */
public enum HologresMetricEnum {

    //广告位曝光pv
    SLOT_EXPOSURE_PV("slotExposurePV", "count(1)", "sum(count_pv)", "duiba_inner_log_detail_month", "duiba_inner_log_offline", "lab_inner_log_detail_day", "inner_group = 1 and inner_type in (2, 151)", "广告位曝光pv"),

    //广告位曝光uv
    SLOT_EXPOSURE_UV("slotExposureUV", "approx_count_distinct(consumer_id)", "approx_count_distinct_unnest(consumer_array)", "duiba_inner_log_detail_month", "duiba_inner_log_offline", "", "inner_group = 1 and inner_type in (2, 151)", "广告位曝光uv"),

    //广告位点击pv
    SLOT_CLICK_PV("slotClickPV", "count(1)", "sum(count_pv)", "duiba_inner_log_detail_month", "duiba_inner_log_offline", "lab_inner_log_detail_day", "inner_group = 1 and inner_type in (3, 152)", "广告位点击pv"),

    //广告位点击uv
    SLOT_CLICK_UV("slotClickUV", "approx_count_distinct(consumer_id)", "approx_count_distinct_unnest(consumer_array)", "duiba_inner_log_detail_month", "duiba_inner_log_offline", "", "inner_group = 1 and inner_type in (3, 152)", "广告位点击uv"),

    //广告位访问pv
    SLOT_VISIT_PV("slotVisitPV", "count(1)", "sum(count_pv)", "duiba_access_log_detail_month", "duiba_access_log_offline", "", "url_host = 'activity.tuia.cn' and tenter='SOW'", "广告位访问pv"),

    //广告位访问uv
    SLOT_VISIT_UV("slotVisitUV", "approx_count_distinct(consumer_id)", "approx_count_distinct_unnest(consumer_array)", "duiba_access_log_detail_month", "duiba_access_log_offline", "", "url_host = 'activity.tuia.cn' and tenter='SOW'", "广告位访问uv"),

    //媒体线-活动请求pv
    APP_ACTIVITY_REQUEST_PV("appActivityRequestPV", "count(1)", "sum(count_pv)", "duiba_access_log_detail_month", "duiba_access_log_offline", "lab_access_log_detail_day", "url_host = 'activity.tuia.cn' and (url_path in('/activity/index','/mainmeet/index','/actcenter/index','/direct/index') or (url_path in('/plugintools/timingindex','/plugintools/index','/plugintools/embeddedindex','/plugintools/responsiveindex') and dpm_b=38))", "活动请求pv"),

    //媒体线-活动请求uv
    APP_ACTIVITY_REQUEST_UV("appActivityRequestUV", "approx_count_distinct(consumer_id)", "approx_count_distinct_unnest(consumer_array)", "duiba_access_log_detail_month", "duiba_access_log_offline", "lab_access_log_detail_day", "url_host = 'activity.tuia.cn' and (url_path in('/activity/index','/mainmeet/index','/actcenter/index','/direct/index') or (url_path in('/plugintools/timingindex','/plugintools/index','/plugintools/embeddedindex','/plugintools/responsiveindex') and dpm_b=38))", "活动请求uv"),

    //媒体线-活动参与pv
    APP_ACTIVITY_JOIN_PV("appActivityJoinPV", "count(1)", "sum(count_pv)", "duiba_access_log_detail_month", "duiba_access_log_offline", "lab_access_log_detail_day", "url_host = 'activity.tuia.cn' and url_path in ('/activity/dojoin','/plugintools/dojoin')", "活动参与pv"),

    //媒体线-活动参与uv
    APP_ACTIVITY_JOIN_UV("appActivityJoinUV", "approx_count_distinct(consumer_id)", "approx_count_distinct_unnest(consumer_array)", "duiba_access_log_detail_month", "duiba_access_log_offline", "lab_access_log_detail_day", "url_host = 'activity.tuia.cn' and url_path in ('/activity/dojoin','/plugintools/dojoin')", "活动参与uv"),

    //媒体线-pv活动参与
    APP_ACTIVITY_JOIN_RID("appActivityJoinRid", "approx_count_distinct(rid)", "approx_count_distinct_unnest(consumer_array)", "duiba_access_log_detail_month", "duiba_access_log_offline", "lab_access_log_detail_day", "url_host = 'activity.tuia.cn' and url_path in ('/activity/dojoin','/plugintools/dojoin')", "pv活动参与"),

    //活动线-活动请求pv
    ACTIVITY_REQUEST_PV("activityRequestPV", "count(1)", "sum(count_pv)", "duiba_access_log_detail_month", "duiba_access_log_offline", "", "activity_stage = 2", "活动请求pv"),

    //活动线-活动请求uv
    ACTIVITY_REQUEST_UV("activityRequestUV", "approx_count_distinct(consumer_id)", "approx_count_distinct_unnest(consumer_array)", "duiba_access_log_detail_month", "duiba_access_log_offline", "", "activity_stage = 2", "活动请求uv"),

    //活动线-活动参与pv
    ACTIVITY_JOIN_PV("activityJoinPV", "count(1)", "sum(count_pv)", "duiba_access_log_detail_month", "duiba_access_log_offline", "", "activity_stage = 3", "活动参与pv"),

    //活动线-活动参与uv
    ACTIVITY_JOIN_UV("activityJoinUV", "approx_count_distinct(consumer_id)", "approx_count_distinct_unnest(consumer_array)", "duiba_access_log_detail_month", "duiba_access_log_offline", "", "activity_stage = 3", "活动参与uv"),

    //券请求pv
    COUPON_REQUEST_PV("couponRequestPV", "count(1)", "sum(count_pv)", "duiba_inner_log_detail_month", "duiba_inner_log_offline", "lab_inner_log_detail_day", "inner_group = 1 and inner_type = 23", "券请求pv"),

    //券请求uv
    COUPON_REQUEST_UV("couponRequestUV", "approx_count_distinct(consumer_id)", "approx_count_distinct_unnest(consumer_array)", "duiba_inner_log_detail_month", "duiba_inner_log_offline", "lab_inner_log_detail_day", "inner_group = 1 and inner_type = 23", "券请求uv"),

    //发券量pv
    LAUNCH_COUPON_PV("launchCouponPV", "count(1)", "sum(count_pv)", "duiba_inner_log_detail_month", "duiba_inner_log_offline", "lab_inner_log_detail_day", "inner_group = 1 and inner_type = 20", "发券量pv"),

    //风控免费券发券量pv
    RISK_LAUNCH_COUPON_PV("riskLaunchCouponPV", "count(case when risk_type in (1, 2) then 1 else null end)", "sum(case when risk_type != 0 then count_pv else null end)", "duiba_inner_log_detail_month", "duiba_inner_log_offline", "lab_inner_log_detail_day", "inner_group = 1 and inner_type = 20", "风控免费券发券量pv"),

    //付费券发券量pv
    LAUNCH_PAY_COUPON_PV("launchPayCouponPV", "count(case when is_free = 0 then 1 else null end)", "sum(case when is_free = 0 then count_pv else null end)", "duiba_inner_log_detail_month", "duiba_inner_log_offline", "lab_inner_log_detail_day", "inner_group = 1 and inner_type = 20", "付费券发券量pv"),

    //免费券发券量pv
    LAUNCH_FREE_COUPON_PV("launchFreeCouponPV", "count(case when is_free = 1 then 1 else null end)", "sum(case when is_free = 1 then count_pv else null end)", "duiba_inner_log_detail_month", "duiba_inner_log_offline", "lab_inner_log_detail_day", "inner_group = 1 and inner_type = 20", "免费券发券量pv"),

    //发券计划填充数量
    LAUNCH_PLAN_FILL_UV("launchPlanFillUV", "approx_count_distinct(advert_id)", "", "duiba_inner_log_detail_month", "", "", "inner_group = 1 and inner_type = 20", "发券计划填充数量"),

    //券曝光pv
    COUPON_EXPOSURE_PV("couponExposurePV", "count(1)", "sum(count_pv)", "duiba_inner_log_detail_month", "duiba_inner_log_offline", "lab_inner_log_detail_day", "inner_group = 1 and inner_type = 22", "券曝光pv"),

    //券普通点击pv
    COUPON_CLICK_PV("couponClickPV", "count(1)", "sum(count_pv)", "duiba_inner_log_detail_month", "duiba_inner_log_offline", "", "inner_group = 1 and inner_type = 21", "券普通点击pv"),

    //券普通点击uv
    COUPON_CLICK_UV("couponClickUV", "approx_count_distinct(consumer_id)", "approx_count_distinct_unnest(consumer_array)", "duiba_inner_log_detail_month", "duiba_inner_log_offline", "", "inner_group = 1 and inner_type = 21", "券普通点击uv"),

    //券计费点击pv
    COUPON_EFFECT_CLICK_PV("couponEffectClickPV", "count(1)", "sum(count_pv)", "duiba_inner_log_detail_month", "duiba_inner_log_offline", "lab_inner_log_detail_day", "inner_group = 1 and inner_type = 25", "券计费点击pv"),

    //表单类券点击pv
    FORM_COUPON_CLICK_PV("formCouponClickPV", "count(case when form_advert = 1 then 1 else null end)", "sum(case when form_advert = 1 then count_pv else null end)", "duiba_inner_log_detail_month", "duiba_inner_log_offline", "", "inner_group = 1 and inner_type = 25", "表单类券点击pv"),

    //消耗
    CONSUME("consume", "sum(fee)", "sum(fee)", "duiba_inner_log_detail_month", "duiba_inner_log_offline", "lab_inner_log_detail_day", "inner_group = 1 and inner_type = 25", "消耗"),

    //作弊消耗
    CHEAT_CONSUME("cheatConsume", "SUM(case when risk_type in('1','2')then fee else 0 end)", "SUM(case when risk_type in('1','2')then fee else 0 end)", "duiba_inner_log_detail_month", "duiba_inner_log_offline", "lab_inner_log_detail_day", "inner_group = 1 and inner_type = 25", "作弊消耗"),

    //增值广告消耗
    ENCOURAGE_CONSUME("encourageConsume", "sum(case when advert_type = 6 then fee else null end)", "sum(case when advert_type = 6 then fee else null end)", "duiba_inner_log_detail_month", "duiba_inner_log_offline", "", "inner_group = 1 and inner_type = 25", "增值广告消耗"),

    //落地页曝光pv
    LP_EXPOSE_PV("lpExposePV", "count(1)", "sum(count_pv)", "duiba_inner_log_detail_month", "duiba_inner_log_offline", "lab_inner_log_detail_day", "inner_group = 1 and inner_type = 7", "落地页曝光pv"),

    //落地页曝光uv
    LP_EXPOSE_UV("lpExposeUV", "approx_count_distinct(consumer_id)", "approx_count_distinct_unnest(consumer_array)", "duiba_inner_log_detail_month", "duiba_inner_log_offline", "", "inner_group = 1 and inner_type = 7", "落地页曝光uv"),

    //落地页转化pv
    LP_CLICK_PV("lpClickPV", "count(1)", "sum(count_pv)", "duiba_inner_log_detail_month", "duiba_inner_log_offline", "lab_inner_log_detail_day", "inner_group = 1 and inner_type = 8", "落地页转化pv"),

    //落地页转化uv
    LP_CLICK_UV("lpClickUV", "approx_count_distinct(consumer_id)", "approx_count_distinct_unnest(consumer_array)", "duiba_inner_log_detail_month", "duiba_inner_log_offline", "", "inner_group = 1 and inner_type = 8", "落地页转化uv"),

    //表单类落地页转化pv
    FORM_LP_CLICK_PV("formLpClickPV", "count(case when form_advert = 1 then 1 else null end)", "sum(case when form_advert = 1 then count_pv else null end)", "duiba_inner_log_detail_month", "", "duiba_inner_log_offline", "inner_group = 1 and inner_type = 8", "表单类落地页转化pv"),

    //后端转化类型-安装pv
    INSTALL_PV("installPv", "count(case when backend_effect_type = 1 then 1 else null end)", "", "duiba_inner_log_detail_month", "", "lab_inner_log_detail_day", "inner_group = 1 and inner_type = 61", "后端转化类型-安装pv"),

    //后端转化类型-安装uv
    INSTALL_UV("installUv", "approx_count_distinct(case when backend_effect_type = 1 then consumer_id else null end)", "", "duiba_inner_log_detail_month", "", "lab_inner_log_detail_day", "inner_group = 1 and inner_type = 61", "后端转化类型-安装uv"),

    //后端转化类型-启动pv
    START_PV("startPv", "count(case when backend_effect_type = 2 then 1 else null end)", "", "duiba_inner_log_detail_month", "", "lab_inner_log_detail_day", "inner_group = 1 and inner_type = 61", "后端转化类型-启动pv"),

    //后端转化类型-启动uv
    START_UV("startUv", "approx_count_distinct(case when backend_effect_type = 2 then consumer_id else null end)", "", "duiba_inner_log_detail_month", "", "lab_inner_log_detail_day", "inner_group = 1 and inner_type = 61", "后端转化类型-启动uv"),

    //后端转化类型-注册pv
    REGISTE_PV("registePv", "count(case when backend_effect_type = 3 then 1 else null end)", "", "duiba_inner_log_detail_month", "", "lab_inner_log_detail_day", "inner_group = 1 and inner_type = 61", "后端转化类型-注册pv"),

    //后端转化类型-注册uv
    REGISTE_UV("registeUv", "approx_count_distinct(case when backend_effect_type = 3 then consumer_id else null end)", "", "duiba_inner_log_detail_month", "", "lab_inner_log_detail_day", "inner_group = 1 and inner_type = 61", "后端转化类型-注册uv"),

    //后端转化类型-注册消耗
    REGISTE_CONSUME("registeConsume", "sum(a_fee)", "", "duiba_inner_log_detail_month", "", "lab_inner_log_detail_day", "inner_group = 1 and inner_type = 61 and backend_effect_type = 3", "后端转化类型-注册消耗"),

    //后端转化类型-激活pv
    ACTIVATE_PV("activatePv", "count(case when backend_effect_type = 4 then 1 else null end)", "", "duiba_inner_log_detail_month", "", "lab_inner_log_detail_day", "inner_group = 1 and inner_type = 61", "后端转化类型-激活pv"),

    //后端转化类型-激活uv
    ACTIVATE_UV("activateUv", "approx_count_distinct(case when backend_effect_type = 4 then consumer_id else null end)", "", "duiba_inner_log_detail_month", "", "lab_inner_log_detail_day", "inner_group = 1 and inner_type = 61", "后端转化类型-激活uv"),

    //后端转化类型-激活消耗
    ACTIVATE_CONSUME("activateConsume", "sum(a_fee)", "", "duiba_inner_log_detail_month", "", "lab_inner_log_detail_day", "inner_group = 1 and inner_type = 61 and backend_effect_type = 4", "后端转化类型-激活消耗"),

    //后端转化类型-登录pv
    LOGIN_PV("loginPv", "count(case when backend_effect_type = 5 then 1 else null end)", "", "duiba_inner_log_detail_month", "", "lab_inner_log_detail_day", "inner_group = 1 and inner_type = 61", "后端转化类型-登录pv"),

    //后端转化类型-登录uv
    LOGIN_UV("loginUv", "approx_count_distinct(case when backend_effect_type = 5 then consumer_id else null end)", "", "duiba_inner_log_detail_month", "", "lab_inner_log_detail_day", "inner_group = 1 and inner_type = 61", "后端转化类型-登录uv"),

    //后端转化类型-付费pv
    PAY_PV("payPv", "count(case when backend_effect_type = 6 then 1 else null end)", "", "duiba_inner_log_detail_month", "", "lab_inner_log_detail_day", "inner_group = 1 and inner_type = 61", "后端转化类型-付费pv"),

    //后端转化类型-付费uv
    PAY_UV("payUv", "approx_count_distinct(case when backend_effect_type = 6 then consumer_id else null end)", "", "duiba_inner_log_detail_month", "", "lab_inner_log_detail_day", "inner_group = 1 and inner_type = 61", "后端转化类型-付费uv"),

    //后端转化类型-付费消耗
    PAY_CONSUME("payConsume", "sum(a_fee)", "", "duiba_inner_log_detail_month", "", "lab_inner_log_detail_day", "inner_group = 1 and inner_type = 61 and backend_effect_type = 6", "后端转化类型-付费消耗"),

    //后端转化类型-进件pv
    ENTRY_PV("entryPv", "count(case when backend_effect_type = 7 then 1 else null end)", "", "duiba_inner_log_detail_month", "", "lab_inner_log_detail_day", "inner_group = 1 and inner_type = 61", "后端转化类型-进件pv"),

    //后端转化类型-进件uv
    ENTRY_UV("entryUv", "approx_count_distinct(case when backend_effect_type = 7 then consumer_id else null end)", "", "duiba_inner_log_detail_month", "", "lab_inner_log_detail_day", "inner_group = 1 and inner_type = 61", "后端转化类型-进件uv"),

    //后端转化类型-进件消耗
    ENTRY_CONSUME("entryConsume", "sum(a_fee)", "", "duiba_inner_log_detail_month", "", "lab_inner_log_detail_day", "inner_group = 1 and inner_type = 61 and backend_effect_type = 7", "后端转化类型-进件消耗"),

    //后端转化类型-完件pv
    FINISH_PV("finishPv", "count(case when backend_effect_type = 8 then 1 else null end)", "", "duiba_inner_log_detail_month", "", "lab_inner_log_detail_day", "inner_group = 1 and inner_type = 61", "后端转化类型-完件pv"),

    //后端转化类型-完件uv
    FINISH_UV("finishUv", "approx_count_distinct(case when backend_effect_type = 8 then consumer_id else null end)", "", "duiba_inner_log_detail_month", "", "lab_inner_log_detail_day", "inner_group = 1 and inner_type = 61", "后端转化类型-完件uv"),

    //后端转化类型-完件消耗
    FINISH_CONSUME("finishConsume", "sum(a_fee)", "", "duiba_inner_log_detail_month", "", "lab_inner_log_detail_day", "inner_group = 1 and inner_type = 61 and backend_effect_type = 8", "后端转化类型-完件消耗"),

    //后端转化类型-签收pv
    SIGN_PV("signPv", "count(case when backend_effect_type = 9 then 1 else null end)", "", "duiba_inner_log_detail_month", "", "lab_inner_log_detail_day", "inner_group = 1 and inner_type = 61", "后端转化类型-签收pv"),

    //后端转化类型-签收uv
    SIGN_UV("signUv", "approx_count_distinct(case when backend_effect_type = 9 then consumer_id else null end)", "", "duiba_inner_log_detail_month", "", "lab_inner_log_detail_day", "inner_group = 1 and inner_type = 61", "后端转化类型-签收uv"),

    //后端转化类型-签收消耗
    SIGN_CONSUME("signConsume", "sum(a_fee)", "", "duiba_inner_log_detail_month", "", "lab_inner_log_detail_day", "inner_group = 1 and inner_type = 61 and backend_effect_type = 9", "后端转化类型-签收消耗"),

    //后端转化类型-拒签pv
    DENY_PV("denyPv", "count(case when backend_effect_type = 10 then 1 else null end)", "", "duiba_inner_log_detail_month", "", "lab_inner_log_detail_day", "inner_group = 1 and inner_type = 61", "后端转化类型-拒签pv"),

    //后端转化类型-拒签uv
    DENY_UV("denyUv", "approx_count_distinct(case when backend_effect_type = 10 then consumer_id else null end)", "", "duiba_inner_log_detail_month", "", "lab_inner_log_detail_day", "inner_group = 1 and inner_type = 61", "后端转化类型-拒签uv"),

    //后端转化类型-出单pv
    ORDER_PV("orderPv", "count(case when backend_effect_type = 11 then 1 else null end)", "", "duiba_inner_log_detail_month", "", "lab_inner_log_detail_day", "inner_group = 1 and inner_type = 61", "后端转化类型-出单pv"),

    //后端转化类型-订单取消pv
    CANCEL_PV("cancelPv", "count(case when backend_effect_type = 12 then 1 else null end)", "", "duiba_inner_log_detail_month", "", "lab_inner_log_detail_day", "inner_group = 1 and inner_type = 61", "后端转化类型-订单取消pv"),

    //视频活动参与pv
    VIDEO_ACTIVITY_JOIN_PV("videoActivityJoinPV", "count(1)", "", "duiba_access_log_detail_month", "", "", "dpm_b=66 and url_host = 'activity.tuia.cn' and url_path in ('/statistics/click','/tuia-activity-booter/statistics/click')", "视频活动参与pv"),

    //视频活动参与uv
    VIDEO_ACTIVITY_JOIN_UV("videoActivityJoinUV", "approx_count_distinct(consumer_id)", "", "duiba_access_log_detail_month", "", "", "dpm_b=66 and url_host = 'activity.tuia.cn' and url_path in ('/statistics/click','/tuia-activity-booter/statistics/click')", "视频活动参与uv"),

    //看视频按钮点击次数
    WATCH_VIDEO_CLICK_PV("watchVideoClickPV", "count(1)", "", "duiba_access_log_detail_month", "", "", "enc_video_module_type = 2 and url_host = 'activity.tuia.cn' and url_path in ('/statistics/click','/tuia-activity-booter/statistics/click')", "看视频按钮点击pv"),

    //看视频按钮点击uv
    WATCH_VIDEO_CLICK_UV("watchVideoClickUV", "approx_count_distinct(consumer_id)", "", "duiba_access_log_detail_month", "", "", "enc_video_module_type = 2 and url_host = 'activity.tuia.cn' and url_path in ('/statistics/click','/tuia-activity-booter/statistics/click')", "看视频按钮点击uv"),

    //看视频弹窗点击关闭按钮次数
    CLOSE_WINDOW_CLICK_PV("closeWindowClickPV", "count(1)", "", "duiba_access_log_detail_month", "", "", "enc_video_module_type = 3 and url_host = 'activity.tuia.cn' and url_path in ('/statistics/click','/tuia-activity-booter/statistics/click')", "看视频弹窗点击关闭按钮pv"),

    //看视频弹窗点击关闭按钮uv
    CLOSE_WINDOW_CLICK_UV("closeWindowClickUV", "approx_count_distinct(consumer_id)", "", "duiba_access_log_detail_month", "", "", "enc_video_module_type = 3 and url_host = 'activity.tuia.cn' and url_path in ('/statistics/click','/tuia-activity-booter/statistics/click')", "看视频弹窗点击关闭按钮uv"),

    //看视频弹窗曝光次数
    WINDOW_EXPOSURE_PV("windowExposurePV", "count(1)", "", "duiba_exposure_log_detail_month", "", "", "enc_video_module_type = 1", "看视频弹窗曝光pv"),

    //看视频弹窗曝光uv
    WINDOW_EXPOSURE_UV("windowExposureUV", "approx_count_distinct(consumer_id)", "", "duiba_exposure_log_detail_month", "", "", "enc_video_module_type = 1", "看视频弹窗曝光uv"),


    //只提供当天的指标列表，不提供历史聚合数据
    //下载成功数为SDK下载补丁成功数量down_patch_succ_uv
    DOWN_PATCH_SUCC_UV("downPatchSuccUv", "approx_count_distinct(consumer_id)", "approx_count_distinct_unnest(consumer_array)", "duiba_inner_log_detail_day", "", "", "inner_group = 1 and inner_type = 186 and  download_status = 1", "sdk热更新,SDK下载补丁成功数量"),

    //生效数为补丁成功生效的数量  patch_succ_effect_uv
    DOWN_SUCC_EFFECT_UV("downSuccEffectUv", "approx_count_distinct(consumer_id)", "approx_count_distinct_unnest(consumer_array)", "duiba_inner_log_detail_day", "", "", "inner_group = 1 and inner_type = 186 and patch_type = 2", "sdk热更新,补丁成功生效的数量"),

    //SDK版本总数为该sdk版本总用户数 sdk_uv
    SDK_UV("sdkUv", "approx_count_distinct(consumer_id)", "approx_count_distinct_unnest(consumer_array)", "duiba_inner_log_detail_day", "", "", "inner_group = 1 and inner_type = 164 and sdk_report_type = 1", "sdk热更新,sdk版本总用户数"),

    //total_times_pv,启动次数   sum(case when sdk_report_type = 1 then count_pv else null end)--pv
    TOTAL_TIMES_PV("totalTimesPv", "count(case when sdk_report_type = 1 then 1 else null end)", "", "duiba_inner_log_detail_day", "", "", "inner_group = 1 and inner_type = 164 and sdk_source != 1", "启动次数"),

    // total_device_uv,启动设备数  count(distinct case when sdk_report_type = 1 then device_uv else null end)--uv
    TOTAL_DEVICES_UV("totalDevicesUv", "approx_count_distinct(case when sdk_report_type = 1 then consumer_id else null end)", "", "duiba_inner_log_detail_day", "", "", "inner_group = 1 and inner_type = 164 and sdk_source != 1", "启动设备数"),

    // crash_times_pv, 崩溃次数  sum(case when sdk_report_type = 2 then count_pv else null end)--pv
    CRASH_TIMES_PV("crashTimesPv", "count(case when sdk_report_type = 2 then 1 else null end)", "", "duiba_inner_log_detail_day", "", "", "inner_group = 1 and inner_type = 164 and sdk_source != 1", "崩溃数"),

    //crash_device_uv 影响设备数  count(distinct case when sdk_report_type = 2 then device_uv else null end)--uv
    CRASH_DEVICES_UV("crashDevicesUv", "approx_count_distinct(case when sdk_report_type = 2 then consumer_id else null end)", "", "duiba_inner_log_detail_day", "", "", "inner_group = 1 and inner_type = 164 and sdk_source != 1", "崩溃设备数"),

    //活动唤醒pv
    ACTIVITY_WAKE_PV("activityWakePv", "count(1)", "", "duiba_ext01_log_detail_day", "", "", "ext_group = 1 and ext_type = 2", "活动唤醒pv"),

    //活动唤醒uv
    ACTIVITY_WAKE_UV("activityWakeUv", "approx_count_distinct(consumer_id)", "", "duiba_ext01_log_detail_day", "", "", "ext_group = 1 and ext_type = 2", "活动唤醒uv"),

    //活动加载pv
    ACTIVITY_LOAD_PV("activityLoadPv", "count(1)", "", "duiba_ext01_log_detail_day", "", "", "ext_group = 1 and ext_type = 7", "活动加载pv"),

    //活动加载uv
    ACTIVITY_LOAD_UV("activityLoadUv", "approx_count_distinct(consumer_id)", "", "duiba_ext01_log_detail_day", "", "", "ext_group = 1 and ext_type = 7", "活动加载uv"),

    //插件活动访问pv
    PLUGIN_REQUEST_PV("pluginRequestPv", "count(1)", "", "duiba_inner_log_detail_day", "", "", "inner_group = 1 and inner_type = 147", "插件活动访问pv"),

    //插件活动访问uv
    PLUGIN_REQUEST_UV("pluginRequestUv", "approx_count_distinct(consumer_id)", "", "duiba_inner_log_detail_day", "", "", "inner_group = 1 and inner_type = 147", "插件活动访问uv"),

    //adx曝光pv
    ADX_EXPOSURE_PV("adxExposurePv", "sum(case when adx_log_type = 0 then count_pv else 0 end)", "", "adx_log_sum_day", "", "", "inner_group = 1 and inner_type in (111,191)", "adx曝光pv"),

    //adx消耗 单位分
    ADX_CONSUME("adxConsume", "sum(case when adx_log_type in( 0,1) then fee else 0 end)/10000000", "", "adx_log_sum_day", "", "", "inner_group = 1 and inner_type in(111,191,192)", "adx消耗 单位分"),

    //adx点击
    ADX_CLICK_PV("adxClickPv", "sum(case when adx_log_type = 1 then count_pv else 0 end)", "", "adx_log_sum_day", "", "", "inner_group = 1 and inner_type in (111,192)", "adx点击"),

    //adx竞价成功
    ADX_BID_SUCCESS_PV("adxBidSuccessPv", "sum(case when adx_log_type = 2 then count_pv else 0 end)", "", "adx_log_sum_day", "", "", "inner_group = 1 and inner_type in (111,193)", "adx竞价成功"),

    //adx竞价返回
    ADX_BID_RETURN_PV("adxBidReturnPv", "sum(case when adx_log_type = 3 then count_pv else 0 end)", "", "adx_log_sum_day", "", "", "inner_group = 1 and inner_type = 111", "adx竞价返回"),

    //adx最终参与竞价出价
    ADX_FINAL_BID_FEE("adxFinalBidFee", "sum(case when adx_log_type = 5 then fee else 0 end)", "", "adx_log_sum_day", "", "", "inner_group = 1 and inner_type in(111,194)", "adx最终参与竞价出价"),

    //adx最终参与竞价
    ADX_FINAL_BID_PV("adxFinalBidPv", "sum(case when adx_log_type = 5 then count_pv else 0 end)", "", "adx_log_sum_day", "", "", "inner_group = 1 and inner_type in(111,194)", "adx最终参与竞价"),

    //adx竞价请求
    ADX_BID_REQUEST_PV("adxBidRequestPv", "sum(count_pv)", "", "adx_bid_request_log_minute", "", "", "inner_group =1 and inner_type = 3 and adx_log_type = 4", "adx竞价请求"),

    //广告配置过滤次数
    PACKAGE_FILTER_PV("packageFilterPv", "", "sum(count_pv)", "", "advert_filter_reason_offline", "", "", "广告配置过滤次数"),

    //广告配置进哪吒前竞价次数
    PACKAGE_BID_PV("packageBidPv", "", "sum(count_pv)", "", "tuia_advert_bid_offline", "", "inner_group = 1 and inner_type = 79", "广告配置进哪吒前竞价次数"),

    //广告配置哪吒竞价失败次数
    PACKAGE_NEZHA_BID_FAILED_PV("packageNezhaBidFailedPv", "", "sum(count_pv)", "", "tuia_advert_bid_offline", "", "inner_group = 1 and inner_type = 38 and rank_score < 10", "广告配置哪吒竞价失败次数"),

    //广告配置哪吒竞价score10分
    PACKAGE_NEZHA_BID_SCORE10_PV("packageNezhaBidScore10", "", "sum(count_pv)", "", "tuia_advert_bid_offline", "", "inner_group = 1 and inner_type = 38 and rank_score = 10", "广告配置哪吒竞价score10分"),

    //广告配置哪吒竞价score9分
    PACKAGE_NEZHA_BID_SCORE9_PV("packageNezhaBidScore9", "", "sum(count_pv)", "", "tuia_advert_bid_offline", "", "inner_group = 1 and inner_type = 38 and rank_score = 9", "广告配置哪吒竞价score9分"),

    //广告配置哪吒竞价score8分
    PACKAGE_NEZHA_BID_SCORE8_PV("packageNezhaBidScore8", "", "sum(count_pv)", "", "tuia_advert_bid_offline", "", "inner_group = 1 and inner_type = 38 and rank_score = 8", "广告配置哪吒竞价score8分"),

    //广告配置哪吒竞价score7分
    PACKAGE_NEZHA_BID_SCORE7_PV("packageNezhaBidScore7", "", "sum(count_pv)", "", "tuia_advert_bid_offline", "", "inner_group = 1 and inner_type = 38 and rank_score = 7", "广告配置哪吒竞价score7分"),

    //广告配置哪吒竞价score6分
    PACKAGE_NEZHA_BID_SCORE6_PV("packageNezhaBidScore6", "", "sum(count_pv)", "", "tuia_advert_bid_offline", "", "inner_group = 1 and inner_type = 38 and rank_score in ( 5, 6 ) ", "广告配置哪吒竞价score6分"),


    //广告配置哪吒竞价次数
    PACKAGE_NEZHA_BID_PV("packageNezhaBidPv", "", "sum(count_pv)", "", "tuia_advert_bid_offline", "", "inner_group = 1 and inner_type = 38", "广告配置哪吒竞价次数"),

    //竞价ecpm总和
    BID_ECPM_SUM("bidEcpmSum", "", "sum(ecpm)", "", "tuia_advert_bid_offline", "", "inner_group = 1 and inner_type = 38", "广告配置哪吒竞价次数"),

    //竞价rankScore总和
    BID_RANK_SCORE_SUM("bidRankScoreSum", "", "sum(rank_score_sum)", "", "tuia_advert_bid_offline", "", "inner_group = 1 and inner_type = 38", "广告配置哪吒竞价排序分总和"),

    //竞价预估CTR总和
    BID_PRE_CTR_SUM("bidPreCtrSum", "", "sum(pre_ctr)", "", "tuia_advert_bid_offline", "", "inner_group = 1 and inner_type = 38", "竞价预估CTR"),

    //竞价预估CVR总和
    BID_PRE_CVR_SUM("bidPreCvrSum", "", "sum(pre_cvr)", "", "tuia_advert_bid_offline", "", "inner_group = 1 and inner_type = 38", "竞价预估CVR"),

    //竞价统计CTR总和
    BID_STAT_CTR_SUM("bidStatCtrSum", "", "sum(stat_ctr)", "", "tuia_advert_bid_offline", "", "inner_group = 1 and inner_type = 38", "竞价统计CTR"),

    //竞价统计CVR总和
    BID_STAT_CVR_SUM("bidStatCvrSum", "", "sum(stat_cvr)", "", "tuia_advert_bid_offline", "", "inner_group = 1 and inner_type = 38", "竞价统计CVR"),


    //目标转化次数
    TARGET_EFFECT_PV("targetEffectPv", "count(1)", "", "duiba_inner_log_detail_month", "", "lab_inner_log_detail_day", "inner_group = 1 and ((inner_type = 8 and target_effect_type = 0) or (target_effect_type = backend_effect_type and inner_type = 61))", "目标转化次数"),

    //目标转化消耗
    TARGET_EFFECT_CONSUME("targetEffectConsume", "sum(a_fee)", "", "duiba_inner_log_detail_month", "", "lab_inner_log_detail_day", "inner_group = 1 and ((inner_type = 8 and target_effect_type = 0) or (target_effect_type = backend_effect_type and inner_type = 61))", "目标转化消耗"),

    //平均预估CTR
    PRE_CTR_AVG("preCtrAvg", "avg(pre_ctr)", "", "duiba_inner_log_detail_month", "", "", "inner_group = 1 and inner_type = 22", "平均预估CTR"),

    //平均预估CVR总和
    PRE_CVR_AVG("preCvrAvg", "avg(pre_cvr)", "", "duiba_inner_log_detail_month", "", "", "inner_group = 1 and inner_type = 25", "平均预估CVR"),

    //平均统计CTR总和
    STAT_CTR_AVG("statCtrAvg", "avg(stat_ctr)", "", "alg_log_detail_month", "", "", "inner_group = 1 and inner_type = 38", "平均统计CTR"),

    //平均统计CVR总和
    STAT_CVR_AVG("statCvrAvg", "avg(stat_cvr)", "", "alg_log_detail_month", "", "", "inner_group = 1 and inner_type = 38", "平均统计CVR"),

    //平均维稳因子
    FACTOR_AVG("factorAvg", "avg(factor)", "", "alg_log_detail_month", "", "", "inner_group = 1 and inner_type = 38", "平均统计CVR"),

    //平均竞价排序分
    RANK_SCORE_AVG("rankScoreAvg", "avg(rank_score)", "", "alg_log_detail_month", "", "", "inner_group = 1 and inner_type = 38", "平均竞价排序分"),

    //美团adx曝光pv
    MEITUAN_ADX_EXPOSURE_PV("meituanAdxExposurePv", "count(case when adx_log_type = 0 then 1 else null end)", "", "adx_log_sum_day", "", "lab_adx_log_detail_day", "inner_group = 1 and inner_type = 160", "美团adx曝光pv"),

    //美团adx曝光uv
    MEITUAN_ADX_EXPOSURE_UV("meituanAdxExposureUv", "approx_count_distinct(case when adx_log_type = 0 then consumer_id else null end)", "", "adx_log_sum_day", "", "lab_adx_log_detail_day", "inner_group = 1 and inner_type = 160", "美团adx曝光pv"),

    //美团adx消耗
    MEITUAN_ADX_CONSUME("meituanAdxConsume", "sum(adx_fee)", "", "duiba_inner_log_detail_month", "", "lab_inner_log_detail_day", "inner_group = 1 and inner_type = 25", "美团adx消耗"),

    //美团adx点击pv
    MEITUAN_ADX_CLICK_PV("meituanAdxClickPv", "count(case when adx_log_type = 1 then 1 else null end)", "", "adx_log_sum_day", "", "lab_adx_log_detail_day", "inner_group = 1 and inner_type = 160", "美团adx点击"),

    //美团adx点击uv
    MEITUAN_ADX_CLICK_UV("meituanAdxClickUv", "approx_count_distinct(case when adx_log_type = 1 then consumer_id else null end)", "", "adx_log_sum_day", "", "lab_adx_log_detail_day", "inner_group = 1 and inner_type = 160", "美团adx点击"),

    //美团胜出媒体出价总和(1价)(分)
    MEITUAN_ADX_BID_FEE_TOTAL("meituanAdxBidFeeTotal", "sum(case when adx_log_type = 1 then fee else 0 end)", "", "adx_log_sum_day", "", "lab_adx_log_detail_day", "inner_group = 1 and inner_type = 160", "美团胜出媒体出价总和(1价)(分)"),

    //美团广告出价总和(分)
    MEITUAN_ADX_ADVERT_FEE_TOTAL("meituanAdxAdvertFeeTotal", "sum(case when adx_log_type = 3 then fee else 0 end)", "", "adx_log_sum_day", "", "lab_adx_log_detail_day", "inner_group = 1 and inner_type = 160", "美团广告出价总和(分)"),

    //美团adx竞价成功
    MEITUAN_ADX_BID_SUCCESS_PV("meituanAdxBidSuccessPv", "count(case when adx_log_type = 2 then 1 else null end)", "", "adx_log_sum_day", "", "lab_adx_log_detail_day", "inner_group = 1 and inner_type = 160", "美团adx竞价成功"),

    //美团adx竞价返回
    MEITUAN_ADX_BID_RETURN_PV("meituanAdxBidReturnPv", "count(case when adx_log_type = 3 then 1 else null end)", "", "adx_log_sum_day", "", "lab_adx_log_detail_day", "inner_group = 1 and inner_type = 160", "美团adx竞价返回"),

    //美团adx竞价请求pv
    MEITUAN_ADX_BID_REQUEST_PV("meituanAdxBidRequestPv", "count(case when adx_log_type = 4 then 1 else null end)", "", "adx_log_sum_day", "", "lab_adx_log_detail_day", "inner_group = 1 and inner_type = 160", "美团adx竞价请求"),


    //兑吧直播业务对应的指标
    //总的邀请人数，包含直播前和直播中
    TOTAL_INVITE_UV("inviteUV", "approx_count_distinct(live_visitor_id)", "", "duiba_live_invitation_log", "", "", "inner_group = 18 and inner_type = 9 and invitation_type in (1, 2)", "直播邀请总人数，包含直播前和直播中"),

    //直播预约人数
    APPOINTMENT_UV("appointmentUV", "approx_count_distinct(live_visitor_id)", "", "duiba_live_invitation_log", "", "", "inner_group = 18 and inner_type = 9 and invitation_type = 1 and appointment = 1", "直播预约人数"),

    //直播预约并到场的人数
    APPOINTMENT_PRESENT_UV("appointmentPresentUV", "approx_count_distinct(live_visitor_id)", "", "duiba_live_invitation_log", "", "", "inner_group = 18 and inner_type = 9 and invitation_type = 1 and appointment = 1 and present = 1", "直播预约并到场的人数"),

    //直播到场人数
    PRESENT_UV("presentUV", "approx_count_distinct(live_visitor_id)", "", "duiba_live_invitation_log", "", "", "inner_group = 18 and inner_type = 9 and present = 1", "直播到场人数"),

    //客户经理邀请的人数
    AGENT_INVITE_UV("agentInviteUV", "approx_count_distinct(live_visitor_id)", "", "duiba_live_invitation_log", "", "", "inner_group = 18 and inner_type = 9 and agent_id is not null and clue_collector_id is null", "客户经理邀请的人数"),

    //通过渠道邀请的人数
    CHANNEL_INVITE_UV("channelInviteUV", "approx_count_distinct(live_visitor_id)", "", "duiba_live_invitation_log", "", "", "inner_group = 18 and inner_type = 9 and invitation_type in (1, 2) and channel_id is not null", "通过渠道邀请的人数"),

    //裂变邀请人数
    FISSION_INVITE_UV("fissionInviteUV", "approx_count_distinct(live_visitor_id)", "", "duiba_live_invitation_log", "", "", "inner_group = 18 and inner_type = 9 and directly = 0", "裂变邀请人数"),

    //直接邀请并到场的人数
    DIRECT_PRESENT_UV("directPresentUV", "approx_count_distinct(live_visitor_id)", "", "duiba_live_invitation_log", "", "", "inner_group = 18 and inner_type = 9 and directly = 1 and present = 1", "直接邀请并到场的人数"),

    //裂变邀请并到场的人数
    FISSION_PRESENT_UV("fissionPresentUV", "approx_count_distinct(live_visitor_id)", "", "duiba_live_invitation_log", "", "", "inner_group = 18 and inner_type = 9 and directly = 0 and present = 1", "裂变邀请并到场的人数"),

    //直播前-邀请人数
    BEFORE_INVITE_UV("beforeInviteUV", "approx_count_distinct(live_visitor_id)", "", "duiba_live_invitation_log", "", "", "inner_group = 18 and inner_type = 9 and invitation_type = 1", "直播前-邀请人数"),

    //直播前-客户经理邀请的人数
    BEFORE_AGENT_INVITE_UV("beforeAgentInviteUV", "approx_count_distinct(live_visitor_id)", "", "duiba_live_invitation_log", "", "", "inner_group = 18 and inner_type = 9 and invitation_type = 1 and agent_id is not null and clue_collector_id is null", "直播前-客户经理邀请的人数"),

    //直播前-通过渠道邀请的人数
    BEFORE_CHANNEL_INVITE_UV("beforeChannelInviteUV", "approx_count_distinct(live_visitor_id)", "", "duiba_live_invitation_log", "", "", "inner_group = 18 and inner_type = 9 and invitation_type = 1 and channel_id is not null", "直播前-通过渠道邀请的人数"),

    //直播前-直接邀请的人数
    BEFORE_DIRECT_INVITE_UV("beforeDirectInviteUV", "approx_count_distinct(live_visitor_id)", "", "duiba_live_invitation_log", "", "", "inner_group = 18 and inner_type = 9 and invitation_type = 1 and directly = 1", "直播前-直接邀请的人数"),

    //直播前-裂变邀请人数
    BEFORE_FISSION_INVITE_UV("beforeFissionInviteUV", "approx_count_distinct(live_visitor_id)", "", "duiba_live_invitation_log", "", "", "inner_group = 18 and inner_type = 9 and invitation_type = 1 and directly = 0", "直播前-裂变邀请人数"),

    //直播中-邀请人数
    LIVING_INVITE_UV("livingInviteUV", "approx_count_distinct(live_visitor_id)", "", "duiba_live_invitation_log", "", "", "inner_group = 18 and inner_type = 9 and invitation_type = 2", "直播中-邀请人数"),

    //直播中-客户经理邀请的人数
    LIVING_AGENT_INVITE_UV("livingAgentInviteUV", "approx_count_distinct(live_visitor_id)", "", "duiba_live_invitation_log", "", "", "inner_group = 18 and inner_type = 9 and invitation_type = 2 and agent_id is not null and clue_collector_id is null", "直播中-客户经理邀请的人数"),

    //直播中-通过渠道邀请的人数
    LIVING_CHANNEL_INVITE_UV("livingChannelInviteUV", "approx_count_distinct(live_visitor_id)", "", "duiba_live_invitation_log", "", "", "inner_group = 18 and inner_type = 9 and invitation_type = 2 and channel_id is not null", "直播中-通过渠道邀请的人数"),

    //直播中-裂变邀请人数
    LIVING_FISSION_INVITE_UV("livingFissionInviteUV", "approx_count_distinct(live_visitor_id)", "", "duiba_live_invitation_log", "", "", "inner_group = 18 and inner_type = 9 and invitation_type = 2 and directly = 0", "直播中-裂变邀请人数"),

    //参与邀请的客户经理人数
    AGENT_UV("agentUV", "approx_count_distinct(agent_id)", "", "duiba_live_invitation_log", "", "", "inner_group = 18 and inner_type = 9 and agent_id is not null and clue_collector_id is null", "参与邀请的客户经理人数"),

    //客户经理-预约的人数
    AGENT_APPOINTMENT_UV("agentAppointmentUV", "approx_count_distinct(live_visitor_id)", "", "duiba_live_invitation_log", "", "", "inner_group = 18 and inner_type = 9 and agent_id is not null and clue_collector_id is null and invitation_type = 1 and appointment = 1", "客户经理-预约的人数"),

    //客户经理-裂变邀请人数
    AGENT_FISSION_INVITE_UV("agentFissionInviteUV", "approx_count_distinct(live_visitor_id)", "", "duiba_live_invitation_log", "", "", "inner_group = 18 and inner_type = 9 and agent_id is not null and clue_collector_id is null and directly = 0", "客户经理-裂变邀请人数"),

    //渠道-预约的人数
    CHANNEL_APPOINTMENT_UV("channelAppointmentUV", "approx_count_distinct(live_visitor_id)", "", "duiba_live_invitation_log", "", "", "inner_group = 18 and inner_type = 9 and channel_id is not null and invitation_type = 1 and appointment = 1", "渠道-预约的人数"),

    //渠道-到场的人数
    CHANNEL_PRESENT_UV("channelPresentUV", "approx_count_distinct(live_visitor_id)", "", "duiba_live_invitation_log", "", "", "inner_group = 18 and inner_type = 9 and channel_id is not null and present = 1", "渠道-到场的人数"),

    //渠道-裂变的人数
    CHANNEL_FISSION_INVITE_UV("channelFissionInviteUV", "approx_count_distinct(live_visitor_id)", "", "duiba_live_invitation_log", "", "", "inner_group = 18 and inner_type = 9 and channel_id is not null and directly = 0", "渠道-裂变的人数"),

    //观看互动-观看人数
    WATCH_UV("watchUV", "approx_count_distinct(live_visitor_id)", "", "duiba_live_watch_log", "", "", "inner_group = 18 and inner_type = 10 and interact_type = 4 ", "观看互动-观看人数"),

    //观看互动-分享次数
    SHARE_PV("sharePV", "count(1)", "", "duiba_live_watch_log", "", "", "inner_group = 18 and inner_type = 10 and interact_type = 1", "观看互动-分享次数"),

    //观看互动-分享人数
    SHARE_UV("shareUV", "approx_count_distinct(live_visitor_id)", "", "duiba_live_watch_log", "", "", "inner_group = 18 and inner_type = 10 and interact_type = 1", "观看互动-分享人数"),

    //观看互动-关注直播间人数
    FOCUS_LIVE_UV("focusLiveUV", "approx_count_distinct(live_visitor_id)", "", "duiba_live_watch_log", "", "", "inner_group = 18 and inner_type = 10 and interact_type = 2", "观看互动-关注直播间人数"),

    //观看互动-预约下场直播人数
    APPOINTMENT_LIVE_UV("appointmentLiveUV", "approx_count_distinct(live_visitor_id)", "", "duiba_live_watch_log", "", "", "inner_group = 18 and inner_type = 10 and interact_type = 3", "观看互动-预约下场直播人数"),

    //红包-红包领取人数
    MONEY_RECEIVER_PV("moneyReceiverPV", "count(1)", "", "duiba_live_red_packet_log", "", "", "inner_group = 18 and inner_type = 12", "红包-红包领取人数"),

    //红包-红包领取金额
    MONEY_RECEIVE_AMOUNT("moneyReceiveAmount", "sum(receive_amount)", "", "duiba_live_red_packet_log", "", "", "inner_group = 18 and inner_type = 12", "红包-红包领取金额"),

    //红包-手气王红包领取人数
    BIG_MONEY_RECEIVER_PV("bigMoneyReceiverPV", "count(1)", "", "duiba_live_red_packet_log", "", "", "inner_group = 18 and inner_type = 12 and is_standard = 1", "红包-手气王红包领取人数"),

    //红包-获得助力的人数
    MONEY_INVITE_UV("moneyInviteUV", "approx_count_distinct(inviter_id)", "", "duiba_live_luck_red_packet_log", "", "", "inner_group = 18 and inner_type = 13", "红包-获得助力的人数"),

    //红包-助力人数
    MONEY_HELP_UV("moneyHelpUV", "approx_count_distinct(help_user_id)", "", "duiba_live_luck_red_packet_log", "", "", "inner_group = 18 and inner_type = 13", "红包-助力人数"),

    //商品-商品点击次数
    GOODS_CLICK_PV("goodsClickPV", "count(1)", "", "duiba_live_goods_appointment_log", "", "", "inner_group = 18 and inner_type = 11", "商品-商品点击次数"),

    //商品-商品点击人数
    GOODS_CLICK_UV("goodsClickUV", "approx_count_distinct(live_visitor_id)", "", "duiba_live_goods_appointment_log", "", "", "inner_group = 18 and inner_type = 11", "商品-商品点击人数"),




    //商品-商品办卡点击数人数
    GOODS_CARD_UV("goodsCardUV", "approx_count_distinct(live_visitor_id)", "", "duiba_live_item_card_log", "", "", "inner_group = 18 and inner_type = 28", "商品-商品办卡点击人数uv"),


    //商品-商品办卡pv
    GOODS_CARD_PV("goodsCardPV", "count(1)", "", "duiba_live_item_card_log", "", "", "inner_group = 18 and inner_type = 28", "商品-商品办卡pv"),

    //商品-气泡办卡uv
    GOODS_BUBBLE_CARD_UV("goodsBubbleCardUV", "approx_count_distinct(live_visitor_id)", "", "duiba_live_item_card_log", "", "", "inner_group = 18 and inner_type = 28 and position_id = 2", "商品-气泡办卡uv"),

    //商品-气泡办卡pv
    GOODS_BUBBLE_CARD_PV("goodsBubbleCardPV", "count(1)", "", "duiba_live_item_card_log", "", "", "inner_group = 18 and inner_type = 28 and position_id = 2", "商品-气泡办卡pv"),

    //商品-购物车办卡uv
    GOODS_SHOPPING_CAR_CARD_UV("goodsShoppingCarUV", "approx_count_distinct(live_visitor_id)", "", "duiba_live_item_card_log", "", "", "inner_group = 18 and inner_type = 28 and position_id = 3", "商品-购物车办卡uv"),

    //商品-购物车办卡pv
    GOODS_SHOPPING_CAR_CARD_PV("goodsShoppingCarPV", "count(1)", "", "duiba_live_item_card_log", "", "", "inner_group = 18 and inner_type = 28 and position_id = 3", "商品-购物车办卡pv"),

    //商品-直播间办卡uv
    GOODS_STUIO_CARD_UV("goodsStudioUV", "approx_count_distinct(live_visitor_id)", "", "duiba_live_item_card_log", "", "", "inner_group = 18 and inner_type = 28 and position_id = 4", "商品-直播间办卡uv"),

    //商品-直播间办卡pv
    GOODS_STUIO_CARD_PV("goodsStudioPV", "count(1)", "", "duiba_live_item_card_log", "", "", "inner_group = 18 and inner_type = 28 and position_id  = 4", "商品-直播间办卡pv"),


    //直播中-评论人数
    LIVING_COMMENT_UV("livingCommentUv", "approx_count_distinct(live_visitor_id)", "", "duiba_live_comment_log", "", "", "inner_group = 18 and inner_type = 25", "直播中-评论人数"),

    //直播中-评论总条数
    LIVING_COMMENT_PV("livingCommentPv", "count(1)", "", "duiba_live_comment_log", "", "", "inner_group = 18 and inner_type = 25", "直播中-评论总条数"),


    //兑吧活动访问pv
    DUIBA_ACTIVITY_REQUEST_PV("duibaActivityRequestPV", "count(1)", "", "duiba_saas_inner_log", "", "", "inner_group = 2 and inner_type = 79", "兑吧活动访问pv"),

    //兑吧活动访问uv
    DUIBA_ACTIVITY_REQUEST_UV("duibaActivityRequestUV", "approx_count_distinct(consumer_id)", "", "duiba_saas_inner_log", "", "", "inner_group = 2 and inner_type = 79", "兑吧活动访问uv"),

    //兑吧活动参与pv
    DUIBA_ACTIVITY_JOIN_PV("duibaActivityJoinPV", "count(1)", "", "duiba_saas_inner_log", "", "", "inner_group = 2 and inner_type = 80", "兑吧活动参与pv"),

    //兑吧活动参与uv
    DUIBA_ACTIVITY_JOIN_UV("duibaActivityJoinUV", "approx_count_distinct(consumer_id)", "", "duiba_saas_inner_log", "", "", "inner_group = 2 and inner_type = 80", "兑吧活动参与uv"),

    //兑吧活动分享pv
    DUIBA_SHARE_PV("duibaSharePV", "count(1)", "", "duiba_saas_inner_log", "", "", "inner_group = 2 and inner_type = 81", "兑吧活动分享pv"),

    //兑吧活动分享uv
    DUIBA_SHARE_UV("duibaShareUV", "approx_count_distinct(consumer_id)", "", "duiba_saas_inner_log", "", "", "inner_group = 2 and inner_type = 81", "兑吧活动分享uv"),

    //兑吧活动邀请pv
    DUIBA_INVITE_PV("duibaInvitePV", "count(1)", "", "duiba_saas_inner_log", "", "", "inner_group = 2 and inner_type = 82", "兑吧活动邀请pv"),

    //兑吧活动邀请uv
    DUIBA_INVITE_UV("duibaInviteUV", "approx_count_distinct(consumer_id)", "", "duiba_saas_inner_log", "", "", "inner_group = 2 and inner_type = 82", "兑吧活动邀请uv"),

    //兑吧活动助力pv
    DUIBA_HELP_PV("duibaHelpPV", "count(1)", "", "duiba_saas_inner_log", "", "", "inner_group = 2 and inner_type = 83", "兑吧活动助力pv"),

    //兑吧活动助力uv
    DUIBA_HELP_UV("duibaHelpUV", "approx_count_distinct(consumer_id)", "", "duiba_saas_inner_log", "", "", "inner_group = 2 and inner_type = 83", "兑吧活动助力uv"),

    //兑吧活动召回访问pv
    DUIBA_RECALL_PV("duibaRecallPV", "count(1)", "", "duiba_saas_inner_log", "", "", "inner_group = 2 and inner_type = 79 and is_from_share = '0'", "兑吧活动召回pv"),

    //活活动召回访问uv
    DUIBA_RECALL_UV("duibaRecallUV", "approx_count_distinct(consumer_id)", "", "duiba_saas_inner_log", "", "", "inner_group = 2 and inner_type = 79 and is_from_share = '0'", "兑吧活动召回uv"),

    //adx debug工具
    //预估入口素材CTR总值
    ADX_PRE_CTR_TOTAL("adxPreCtrTotal", "sum(pre_ctr_total)", "", "adx_alg_detail_minute_month", "", "", "inner_group = 1 and inner_type = 123", "adx-预估ctr总值"),

    //预估入口素材CTR pv
    ADX_PRE_CTR_COUNT("adxPreCtrCount", "sum(pre_ctr_count)", "", "adx_alg_detail_minute_month", "", "", "inner_group = 1 and inner_type = 123", "adx-预估ctr pv"),

    //统计入口素材CTR总值
    ADX_STAT_CTR_TOTAL("adxStatCtrTotal", "sum(stat_ctr_total)", "", "adx_alg_detail_minute_month", "", "", "inner_group = 1 and inner_type = 123", "adx-统计ctr总值"),

    //统计入口素材CTR pv
    ADX_STAT_CTR_COUNT("adxStatCtrCount", "sum(stat_ctr_count)", "", "adx_alg_detail_minute_month", "", "", "inner_group = 1 and inner_type = 123", "adx-统计ctr pv"),

    //融合入口素材CTR总值
    ADX_MERGER_CTR_TOTAL("adxMergerCtrTotal", "sum(merger_ctr_total)", "", "adx_alg_detail_minute_month", "", "", "inner_group = 1 and inner_type = 123", "adx-融合ctr总值"),

    //融合入口素材CTR pv
    ADX_MERGER_CTR_COUNT("adxMergerCtrCount", "sum(merger_ctr_count)", "", "adx_alg_detail_minute_month", "", "", "inner_group = 1 and inner_type = 123", "adx-融合ctr pv"),

    //预估每pv发券总值
    ADX_PRE_PV_LAUNCH_TOTAL("adxPrePvLaunchTotal", "sum(pre_pv_launch_total)", "", "adx_alg_detail_minute_month", "", "", "inner_group = 1 and inner_type = 123", "adx-预估每pv发券总值"),

    //预估每pv发券 pv
    ADX_PRE_PV_LAUNCH_COUNT("adxPrePvLaunchCount", "sum(pre_pv_launch_count)", "", "adx_alg_detail_minute_month", "", "", "inner_group = 1 and inner_type = 123", "adx-预估每pv发券 pv"),

    //统计每pv发券总值
    ADX_STAT_PV_LAUNCH_TOTAL("adxStatPvLaunchTotal", "sum(stat_pv_launch_total)", "", "adx_alg_detail_minute_month", "", "", "inner_group = 1 and inner_type = 123", "adx-统计每pv发券总值"),

    //统计每pv发券 pv
    ADX_STAT_PV_LAUNCH_COUNT("adxStatPvLaunchCount", "sum(stat_pv_launch_count)", "", "adx_alg_detail_minute_month", "", "", "inner_group = 1 and inner_type = 123", "adx-统计每pv发券 pv"),

    //融合每pv发券总值
    ADX_MERGE_PV_LAUNCH_TOTAL("adxMergePvLaunchTotal", "sum(merge_pv_launch_total)", "", "adx_alg_detail_minute_month", "", "", "inner_group = 1 and inner_type = 123", "adx-融合每pv发券总值"),

    //融合每pv发券 pv
    ADX_MERGE_PV_LAUNCH_COUNT("adxMergePvLaunchCount", "sum(merge_pv_launch_count)", "", "adx_alg_detail_minute_month", "", "", "inner_group = 1 and inner_type = 123", "adx-融合每pv发券 pv"),

    //预估arpu总值
    ADX_PRE_ARPU_TOTAL("adxPreArpuTotal", "sum(pre_arpu_total)", "", "adx_alg_detail_minute_month", "", "", "inner_group = 1 and inner_type = 123", "adx-预估arpu总值"),

    //预估arpu pv
    ADX_PRE_ARPU_COUNT("adxPreArpuCount", "sum(pre_arpu_count)", "", "adx_alg_detail_minute_month", "", "", "inner_group = 1 and inner_type = 123", "adx-预估arpu pv"),

    //统计arpu总值
    ADX_STAT_ARPU_TOTAL("adxStatArpuTotal", "sum(stat_arpu_total)", "", "adx_alg_detail_minute_month", "", "", "inner_group = 1 and inner_type = 123", "adx-统计arpu总值"),

    //统计arpu pv
    ADX_STAT_ARPU_COUNT("adxStatArpuCount", "sum(stat_arpu_count)", "", "adx_alg_detail_minute_month", "", "", "inner_group = 1 and inner_type = 123", "adx-统计arpu pv"),

    //融合arpu总值
    ADX_MERGER_ARPU_TOTAL("adxMergerArpuTotal", "sum(merger_arpu_total)", "", "adx_alg_detail_minute_month", "", "", "inner_group = 1 and inner_type = 123", "adx-融合arpu总值"),

    //融合arpu pv
    ADX_MERGER_ARPU_COUNT("adxMergerArpuCount", "sum(merger_arpu_count)", "", "adx_alg_detail_minute_month", "", "", "inner_group = 1 and inner_type = 123", "adx-融合arpu pv"),

    //融合arpu总值
    ADX_FACTOR_TOTAL("adxFactorTotal", "sum(factor_total)", "", "adx_alg_detail_minute_month", "", "", "inner_group = 1 and inner_type = 123", "adx-维稳因子总值"),

    //融合arpu pv
    ADX_FACTOR_COUNT("adxFactorCount", "sum(factor_count)", "", "adx_alg_detail_minute_month", "", "", "inner_group = 1 and inner_type = 123", "adx-维稳因子 pv"),

    //广告配置过滤次数
    ADX_FILTER_PV("adxFilterPv", "", "sum(count_pv)", "", "adx_filter_reason_offline", "", "", "adx过滤次数"),

    //duiba活动曝光次数
    DUIBA_EXPOSURE_PV("duibaExposurePV", "count(1)", "", "duiba_exposure_log_detail_month", "", "", "app_source = 0", "兑吧活动曝光pv"),

    //兑吧活动曝光uv
    DUIBA_EXPOSURE_UV("duibaExposureUV", "approx_count_distinct(consumer_id)", "", "duiba_exposure_log_detail_month", "", "", "app_source = 0", "兑吧活动曝光uv"),

    //duiba活动点击次数
    DUIBA_CLICK_PV("duibaClickPV", "count(1)", "", "duiba_click_log_detail_month", "", "", "app_source = 0", "兑吧活动点击pv"),

    //兑吧活动点击uv
    DUIBA_CLICK_UV("duibaClickUV", "approx_count_distinct(consumer_id)", "", "duiba_click_log_detail_month", "", "", "app_source = 0", "兑吧活动点击uv"),

    //降级付费出券pv
    COUPON_DEGRADE_PAY_PV("couponDegradePayPV", "count(1)", "", "duiba_inner_log_detail_month", "", "", "inner_group = 1 and inner_type = 20 and launch_scene = 83", "降级付费出券pv"),

    //降级免费出券pv
    COUPON_DEGRADE_FREE_PV("couponDegradeFreePV", "count(1)", "", "duiba_inner_log_detail_month", "", "", "inner_group = 1 and inner_type = 20 and launch_scene = 84", "降级免费出券pv"),

    //平均可投配置数
    USABLE_CONFIG_NUM_AVG("usableConfigNumAvg", "", "sum(usable_config_num_sum)/sum(usable_config_pv)", "", "advert_filter_config_offline", "", "", "平均可投配置数"),

    //平均可投广告数
    USABLE_AD_NUM_AVG("usableAdNumAvg", "", "sum(usable_advert_num_sum)/sum(usable_advert_pv)", "", "advert_filter_config_offline", "", "", "平均可投广告数"),

    //总的可投配置数pv
    USABLE_CONFIG_PV_TOTAL("usableConfigPvTotal", "", "sum(usable_config_pv)", "", "advert_filter_config_offline", "", "", "总的可投配置数pv"),

    //媒体维度券请求pv
    APP_COUPON_REQUEST_PV("couponRequestPV", "", "sum(coupon_request_pv)", "", "tb_app_line_di", "", "", "媒体维度券请求pv"),

    //广告特权库发券pv
    PRIVILEGE_LAUNCH_PV("privilegeLaunchPv", "", "sum(count_pv)", "", "tuia_advert_bid_offline", "", "inner_group = 1 and inner_type = 79 and advert_put_scene = 89", "广告特权库发券pv"),
    //adx debug 工具2.0
    //曝光环节
    //预估入口素材CTR总值
    EXPOSURE_ADX_PRE_CTR_TOTAL("adxPreCtrTotal", "sum(pre_ctr_total)", "", "adx_log_sum_day", "", "", "inner_group = 1 and inner_type in (111,191) and adx_log_type = 0 ", "曝光环节adx-预估ctr总值"),

    //预估入口素材CTR pv
    EXPOSURE_ADX_PRE_CTR_COUNT("adxPreCtrCount", "sum(pre_ctr_count)", "", "adx_log_sum_day", "", "", "inner_group = 1 and inner_type in (111,191) and adx_log_type = 0 ", "曝光环节adx-预估ctr pv"),

    //统计入口素材CTR总值
    EXPOSURE_ADX_STAT_CTR_TOTAL("adxStatCtrTotal", "sum(stat_ctr_total)", "", "adx_log_sum_day", "", "", "inner_group = 1 and inner_type in (111,191) and adx_log_type = 0 ", "曝光环节adx-统计ctr总值"),

    //统计入口素材CTR pv
    EXPOSURE_ADX_STAT_CTR_COUNT("adxStatCtrCount", "sum(stat_ctr_count)", "", "adx_log_sum_day", "", "", "inner_group = 1 and inner_type in (111,191) and adx_log_type = 0 ", "曝光环节adx-统计ctr pv"),

    //融合入口素材CTR总值
    EXPOSURE_ADX_MERGER_CTR_TOTAL("adxMergerCtrTotal", "sum(merger_ctr_total)", "", "adx_log_sum_day", "", "", "inner_group = 1 and inner_type in (111,191) and adx_log_type = 0 ", "曝光环节adx-融合ctr总值"),

    //融合入口素材CTR pv
    EXPOSURE_ADX_MERGER_CTR_COUNT("adxMergerCtrCount", "sum(merger_ctr_count)", "", "adx_log_sum_day", "", "", "inner_group = 1 and inner_type in (111,191) and adx_log_type = 0 ", "曝光环节adx-融合ctr pv"),

    //点击环节
    //预估每pv发券总值
    CLICK_ADX_PRE_PV_LAUNCH_TOTAL("adxPrePvLaunchTotal", "sum(pre_pv_launch_total)", "", "adx_log_sum_day", "", "", "inner_group = 1 and inner_type in (111,192) and adx_log_type = 1 ", "点击环节adx-预估每pv发券总值"),

    //预估每pv发券 pv
    CLICK_ADX_PRE_PV_LAUNCH_COUNT("adxPrePvLaunchCount", "sum(pre_pv_launch_count)", "", "adx_log_sum_day", "", "", "inner_group = 1 and inner_type in (111,192) and adx_log_type = 1 ", "点击环节adx-预估每pv发券 pv"),

    //统计每pv发券总值
    CLICK_ADX_STAT_PV_LAUNCH_TOTAL("adxStatPvLaunchTotal", "sum(stat_pv_launch_total)", "", "adx_log_sum_day", "", "", "inner_group = 1 and inner_type in (111,192) and adx_log_type = 1 ", "点击环节adx-统计每pv发券总值"),

    //统计每pv发券 pv
    CLICK_ADX_STAT_PV_LAUNCH_COUNT("adxStatPvLaunchCount", "sum(stat_pv_launch_count)", "", "adx_log_sum_day", "", "", "inner_group = 1 and inner_type in (111,192) and adx_log_type = 1 ", "点击环节adx-统计每pv发券 pv"),

    //融合每pv发券总值
    CLICK_ADX_MERGE_PV_LAUNCH_TOTAL("adxMergePvLaunchTotal", "sum(merge_pv_launch_total)", "", "adx_log_sum_day", "", "", "inner_group = 1 and inner_type in (111,192) and adx_log_type = 1 ", "点击环节adx-融合每pv发券总值"),

    //融合每pv发券 pv
    CLICK_ADX_MERGE_PV_LAUNCH_COUNT("adxMergePvLaunchCount", "sum(merge_pv_launch_count)", "", "adx_log_sum_day", "", "", "inner_group = 1 and inner_type in (111,192) and adx_log_type = 1 ", "点击adx-融合每pv发券 pv"),

    //发券环节
    //预估arpu总值
    LAUNCH_ADX_PRE_ARPU_TOTAL("adxPreArpuTotal", "sum(pre_arpu)", "", "duiba_inner_log_detail_month", "", "", "inner_group = 1 and inner_type = 20", "发券环节adx-预估arpu总值"),

    //预估arpu pv
    LAUNCH_ADX_PRE_ARPU_COUNT("adxPreArpuCount", "count(case when pre_arpu > 0 then 1 else null end)", "", "duiba_inner_log_detail_month", "", "", "inner_group = 1 and inner_type = 20", "发券环节adx-预估arpu pv"),

    //统计arpu总值
    LAUNCH_ADX_STAT_ARPU_TOTAL("adxStatArpuTotal", "sum(stat_arpu)", "", "duiba_inner_log_detail_month", "", "", "inner_group = 1 and inner_type = 20", "发券环节adx-统计arpu总值"),

    //统计arpu pv
    LAUNCH_ADX_STAT_ARPU_COUNT("adxStatArpuCount", "count(case when stat_arpu > 0 then 1 else null end)", "", "duiba_inner_log_detail_month", "", "", "inner_group = 1 and inner_type = 20", "发券环节adx-统计arpu pv"),

    //融合arpu总值
    LAUNCH_ADX_MERGER_ARPU_TOTAL("adxMergerArpuTotal", "sum(merger_arpu)", "", "duiba_inner_log_detail_month", "", "", "inner_group = 1 and inner_type = 20", "发券环节adx-融合arpu总值"),

    //融合arpu pv
    LAUNCH_ADX_MERGER_ARPU_COUNT("adxMergerArpuCount", "count(case when merger_arpu > 0 then 1 else null end)", "", "duiba_inner_log_detail_month", "", "", "inner_group = 1 and inner_type = 20", "发券环节adx-融合arpu pv"),

    //拉活
    PULL_ALIVE("pullAlive", "case when (slot_activity_type=11 or slot_activity_type=13) then 1 else 0 end", "", "duiba_inner_log_detail_month", "", "", "inner_group = 1 and inner_type in (20,21,22,25)", "是否拉活;1：拉活，0：非拉活"),

    //人群包用户覆盖数
    CROWD_USER_COUNT("crowdUserCount", "approx_count_distinct(device_id)", "", "dmp_upload_crowd", "", "", "", "人群包覆盖用户数"),


    //转化上报数
    EFFECT_REPORT_PV("effectReportPv", "count(1)", "", "duiba_ext02_log_detail_day", "", "", "ext_group = 1 and ext_type =69 ", "转化上报数") ,


    //兑吧-积分商城活动
    //总访问pv
    INTEGRAL_VISIT_PV("integralVisitPv", "", "sum(visit_pv)", "", "dm_developer_detail_di", "", "", "积分商场总访问pv"),

    //总访问uv
    INTEGRAL_VISIT_UV("integralVisitUv", "", "count (distinct consumer_id)", "", "dm_developer_detail_di", "", "visit_pv > 0", "积分商场总访问uv"),

    //总订单量
    MAIN_ORDER_PV("mainOrderPv", "", "count (distinct consumer_id)", "", "dm_developer_detail_di", "", "order_num > 0", "积分商场总订单量"),

    //总兑换人数
    MAIN_ORDER_UV("mainOrderUv", "", "count (distinct consumer_id)", "", "dm_developer_detail_di", "", "order_num > 0", "积分商场兑换人数"),

    //活动参与人数

    //下单量
    ORDER_NUM("orderNum", "", "sum(order_num)", "", "dm_developer_detail_di", "", "", "积分商场下单"),

    //下单成功量
    FINISH_ORDER_NUM("finishOrderNum", "", "sum(finish_order_num)", "", "dm_developer_detail_di", "", "", "积分商场下单成功"),

    //下单uv
    ORDER_NUM_UV("orderNumUv", "", "count (distinct consumer_id)", "", "dm_developer_detail_di", "", "order_num > 0", "积分商场下单UV"),

    //下单成功uv
    FINISH_ORDER_NUM_UV("finishOrderNumUv", "", "count (distinct consumer_id)", "", "dm_developer_detail_di", "", "finish_order_num > 0", "积分商场下单成功Uv"),


    //总积分消耗uv
    TOTAL_FEE_UV("totalFeeUv", "", "count (distinct consumer_id)", "", "dm_developer_detail_di", "", "consume_num > 0", "积分商场下单成功"),

    //兑吧-活动-商品详情页
    //商品访问pv
    GOODS_DETAIL_VISIT_PV("goodsDetailVisitPv", "", "sum(item_visit_pv)", "", "dm_item_detail_di", "", "", "积分商场商品访问pv"),

    //商品访问uv
    GOODS_DETAIL_VISIT_UV("goodsDetailVisitUv", "", "count (distinct consumer_id)", "", "dm_item_detail_di", "", "item_visit_pv > 0", "积分商场商品访问uv"),

    //兑吧-活动
    //访问有效天
    ACTIVITY_VISIT_EFFECT_DAY("activityVisitEffectDay", "", "count(1)", "", "dm_activity_detail_di", "", " activity_visit_pv > 0", "积分商场活动访问有效天"),

    //参与有效天
    ACTIVITY_JOIN_EFFECT_DAY("activityJoinEffectDay", "", "count(1)", "", "dm_activity_detail_di", "", " activity_join_pv > 0", "积分商场活动参与有效天"),

    //活动访问pv
    INTEGRAL_ACTIVITY_VISIT_PV("integralActivityVisitPv", "", "sum(activity_visit_pv)", "", "dm_activity_detail_di", "", "", "积分商场活动访问pv"),

    //活动访问uv
    INTEGRAL_ACTIVITY_VISIT_UV("integralActivityVisitUv", "", "count (distinct consumer_id)", "", "dm_activity_detail_di", "", "activity_visit_pv > 0", "积分商场活动访问pv"),

    //活动参与pv
    INTEGRAL_ACTIVITY_JOIN_PV("integralActivityJoinPv", "", "sum(activity_join_pv)", "", "dm_activity_detail_di", "", "", "积分商场活动访问pv"),

    //活动参与uv
    INTEGRAL_ACTIVITY_JOIN_UV("integralActivityJoinUv", "", "count (distinct consumer_id)", "", "dm_activity_detail_di", "", "activity_join_pv > 0", "积分商场活动访问pv")





    ;


    //指标字段名称
    private final String fieldName;

    //指标sql代码段
    private final String metricSql;

    //指标sql代码段（离线数据）
    private final String offlineMetricSql;

    //指标对应的 hologres 表
    private final String tableName;

    //指标对应的 hologres 表（离线数据）
    private final String offlineTableName;

    //指标对应的 hologres 表（测试平台数据 指标sql用实时）
    private final String abTestTableName;

    //指标特定的查询条件
    private final String condition;

    //指标解释说明
    private final String desc;

    private static final List<String> enumList = new ArrayList<>();

    HologresMetricEnum(String fieldName, String metricSql, String offlineMetricSql, String tableName,
                       String offlineTableName, String abTestTableName, String condition, String desc) {
        this.fieldName = fieldName;
        this.metricSql = metricSql;
        this.offlineMetricSql = offlineMetricSql;
        this.tableName = tableName;
        this.offlineTableName = offlineTableName;
        this.abTestTableName = abTestTableName;
        this.condition = condition;
        this.desc = desc;
    }

    public String getFieldName() {
        return fieldName;
    }

    public String getMetricSql() {
        return metricSql;
    }

    public String getOfflineMetricSql() {
        return offlineMetricSql;
    }

    public String getTableName() {
        return tableName;
    }

    public String getOfflineTableName() {
        return offlineTableName;
    }

    public String getAbTestTableName() {
        return abTestTableName;
    }

    public String getCondition() {
        return condition;
    }

    public String getDesc() {
        return desc;
    }

    public static List<String> getEnumList() {
        return enumList;
    }

    static {
        HologresMetricEnum[] values = HologresMetricEnum.values();
        for (HologresMetricEnum value : values) {
            enumList.add(value.toString());
        }
    }
}
