package cn.com.duiba.bigdata.common.biz.enums.tables.bigdata;

/**
 * @author zhx 2022-02-16
 * hologres表的所有字段说明，枚举字段需要与 HologresDimensionEnum 中的枚举字段相同
 */
public enum DuibaExt02LogDetailDayEnum {

    DATE_PARTITION("date_partition", "按天分区，格式：yyyyMMdd"),

    LOG_UUID("log_uuid", "唯一键"),

    UNIX_TIME("unix_time", "unix时间戳"),

    EXT_GROUP("ext_group", "公司业务分类，大类"),

    EXT_TYPE("ext_type", "日志分类，小类"),

    SLOT_ID("slot_id", "广告位id")

    ;


    //hologres 中表定义的字段名称
    private final String tableFieldName;

    //字段备注
    private final String desc;

    DuibaExt02LogDetailDayEnum(String tableFieldName, String desc) {
        this.tableFieldName = tableFieldName;
        this.desc = desc;
    }

    public String getTableFieldName() {
        return tableFieldName;
    }

    public String getDesc() {
        return desc;
    }
}
