package cn.com.duiba.bigdata.common.biz.enums.tables.duiba_integral_activity;

/**
 * @author 朱宏祥 2022-04-26
 * hologres表的所有字段说明，枚举字段需要与 HologresDimensionEnum 中的枚举字段相同
 * 兑吧-积分商城-活动表
 */
public enum DuibaIntegralActivityLogEnum {

    DATE_PARTITION("date_partition", "按天分区，格式：yyyyMMdd"),

    APP_ID("app_id", "媒体Id"),

    CONSUMER_ID("consumer_id", "用户id"),

    ACTIVITY_TYPE("activity_type", "活动类型"),

    //子活动id
    ACTIVITY_ID ("activity_id","子活动id")


    ;


    //hologres 中表定义的字段名称
    private final String tableFieldName;

    //字段备注
    private final String desc;

    DuibaIntegralActivityLogEnum(String tableFieldName, String desc) {
        this.tableFieldName = tableFieldName;
        this.desc = desc;
    }

    public String getTableFieldName() {
        return tableFieldName;
    }

    public String getDesc() {
        return desc;
    }
}
