package cn.com.duiba.bigdata.common.biz.enums.tables.duiba_live;

/**
 * @author zhx 2021-12-28
 * hologres表的所有字段说明，枚举字段需要与 HologresDimensionEnum 中的枚举字段相同
 */
public enum DuibaLiveItemLogEnum {

    DATE_PARTITION("date_partition", "按天分区，格式：yyyyMMdd"),

    LOG_UUID("log_uuid", "唯一键"),

    UNIX_TIME("unix_time", "unix时间戳"),

    INNER_GROUP("inner_group", "公司业务分类，大类"),

    INNER_TYPE("inner_type", "日志分类，小类"),

    LIVE_ID("live_id", "直播id"),

    LIVE_VISITOR_ID("live_visitor_id", "直播用户id"),

    GOODS_ID("goods_id", "商品id"),

    POSITION_ID("position_id", "位置id，对应dmp埋点")







    ;


    //hologres 中表定义的字段名称
    private final String tableFieldName;

    //字段备注
    private final String desc;

    DuibaLiveItemLogEnum(String tableFieldName, String desc) {
        this.tableFieldName = tableFieldName;
        this.desc = desc;
    }

    public String getTableFieldName() {
        return tableFieldName;
    }

    public String getDesc() {
        return desc;
    }
}
