package cn.com.duiba.bigdata.common.biz.enums;

/**
 * @author xugf
 * Hologres 维度字段
 */
public enum HologresDimensionEnum {

    //媒体id
    APP_ID("app_id", "appId", "int", "媒体id"),

    //广告位id
    SLOT_ID("slot_id", "slotId", "int", "广告位id"),

    //活动id
    ACTIVITY_ID("activity_id", "activityId", "String", "活动id"),

    //广告id
    ADVERT_ID("advert_id", "advertId", "int", "广告id"),

    //广告推广计划id
    ADVERT_PLAN_ID("advert_plan_id", "advertPlanId", "int", "广告推广id"),

    //素材ID
    MATERIAL_ID("material_id", "materialId", "int", "素材ID"),

    //广告定向配置id，0为默认配置
    ORIENTATION_ID("orientation_id", "orientationId", "int", "广告定向配置id; 0为默认配置"),

    //广告主账户id
    ACCOUNT_ID("account_id", "accountId", "int", "广告主账户id"),

    //代理商id
    AGENT_ID("agent_id", "agentId", "int", "代理商id"),

    //广告资源id
    ADVERT_RESOURCE_TAG_ID("advert_resource_tag_id", "advertResourceTagId", "String", "广告资源id"),

    //活动投放类型 1-配置包插件活动,2-活动工具,3-直投页,4-展示广告,5-浮标,6-增值广告,7-活动直投落地页,8-激励视屏,9-新激励视屏,10-增值,11-dp广告
    SLOT_ACTIVITY_TYPE("slot_activity_type", "slotActivityType","int","活动投放类型; 1-配置包插件活动,2-活动工具,3-直投页,4-展示广告,5-浮标,6-增值广告,7-活动直投落地页,8-激励视屏,9-新激励视屏,10-增值,11-dp广告"),

    //ADX推广组id
    GROUP_ID("group_id", "groupId", "int", "ADX推广组id"),

    //ADX资源位id
    RESOURCE_ID("resource_id", "resourceId", "int", "ADX资源位id"),

    //ADX创意id
    IDEA_ID("idea_id", "ideaId", "int", "ADX创意id"),

    //ADX创意素材id
    IDEA_MATERIAL_ID("idea_material_id", "ideaMaterialId", "int", "ADX创意素材id"),

    //ADX创意素材类型 1-单图  2-双图 3-三图 4-视频
    IDEA_MATERIAL_TYPE("idea_material_type", "ideaMaterialType", "int", "ADX创意素材类型"),

    //创建App的来源 0：积分商城（兑吧） 1：广告平台（推啊）
    APP_SOURCE("app_source", "appSource", "int", "创建App的来源; 0：积分商城（兑吧） 1：广告平台（推啊）"),

    //媒体性质 1-在线KA,2-潜力KA,3-普通媒体
    APP_LEVEL("app_level", "appLevel", "int", "媒体性质; 1-在线KA,2-潜力KA,3-普通媒体"),

    //媒体类型 1-在线ka 2-普通媒体 3-rtb-adx 4-rtb-非adx
    APP_TYPE("app_type", "appType", "int", "媒体类型; 1-在线ka 2-普通媒体 3-rtb-adx 4-rtb-非adx "),

    //目标转化类型（广告配置的一个属性）
    TARGET_EFFECT_TYPE("target_effect_type", "targetEffectType", "int", "目标转化类型;（广告配置的一个属性）"),

    //1表示表单类广告
    FORM_ADVERT("form_advert", "formAdvert", "int", "是否表单类广告; 1:是 0：否"),

    //是否免费 (0:收费 1:免费)
    IS_FREE("is_free", "isFree", "int", "是否免费; (0:收费 1:免费)"),

    //新媒体类型appType 0-老媒体，1-新媒体测试发券，2-新媒体,非新媒体测试发券
    NEW_APP_TYPE("new_app_type", "newAppType", "int", "新媒体类型appType; 0-老媒体，1-新媒体测试发券，2-新媒体,非新媒体测试发券"),

    //ae区域  1-华东，2-华北 3-其他
    AE_AREA("ae_area", "aeArea", "int", "ae区域;  1-华东，2-华北 3-其他"),

    //aeId
    AE_ID("ae_id", "aeId", "int", "aeId"),

    //广告类型（推啊 -1-互动式广告，4-展示广告，6-激励广告）
    ADVERT_TYPE("advert_type", "advertType", "int", "广告类型;（推啊 -1-互动式广告，4-展示广告，6-激励广告）"),

    //活动来源 (0-兑吧 1-推啊)
    ACTIVITY_SOURCE("activity_source", "activitySource", "int", "活动来源; (0-兑吧 1-推啊)"),

    //广告位投放活动类型 1-常规活动，2-自定义活动（非深度），3-直投页，4-深度互动，5-原生互动，6-激励互动
    ACTIVITY_TYPE("activity_type", "activityType", "int", "广告位投放活动的类型;（1-常规活动，2-自定义活动（非深度），3-直投页，4-深度互动，5-原生互动，6-激励互动）"),

    //活动投放方式-大类（1:测试 2:算法 3:灰度测试 4:手投）
    ACTIVITY_PUT_TYPE("activity_put_type", "activityPutType", "int", "活动投放方式-大类;（1:测试 2:算法 3:灰度测试 4:手投）"),

    //活动投放模式（1:直投 2: 一次返回拦截 3: 二次返回拦截 4:浮标 5:推荐弹层 6:谢谢参与弹层）
    ACTIVITY_RELEASE_MODE("activity_release_mode", "activityReleaseMode", "int", "活动投放模式;（1:直投 2: 一次返回拦截 3: 二次返回拦截 4:浮标 5:推荐弹层 6:谢谢参与弹层）"),

    //广告位上直投活动的投放方式：仅投1 优投人工2 优投算法3 纯算法4 其他0
    ACTIVITY_RELEASE_SUB_MODE("activity_release_sub_mode", "activityReleaseSubMode", "int", "广告位上直投活动的投放方式; 仅投1 优投人工2 优投算法3 纯算法4 其他0"),

    //广告位投放内容类型 1:活动、2：直投页、3：自定义活动
    RELEASE_CONTENT_TYPE("release_content_type", "releaseContentType", "int", "广告位投放内容类型; 1:活动、2：直投页、3：自定义活动"),

    //adx投放方式 0:依次 1:按比例 2:按算法
    ADX_PUT_TYPE("adx_put_type", "adxPutType", "int", "adx投放方式; 0依次 1按比例 2按算法"),

    //生效的主体类型，1-杭州推啊，2-霍尔果斯推啊
    COMPANY_ID("company_id", "companyId", "int", "生效的主体类型; 1-杭州推啊，2-霍尔果斯推啊"),

    //风控类型 0：正常，1：用户作弊，2：广告位作弊
    RISK_TYPE("risk_type", "riskType", "int", "风控类型; 0：正常，1：用户作弊，2：广告位作弊"),

    //广告位素材id
    SLOT_MATERIAL_ID("slot_material_id", "slotMaterialId", "int", "广告位素材id"),

    //广告位素材投放方式：0-人工 1-算法1.0 2-算法2.0 3-算法返回null降级
    SLOT_MATERIAL_PUT_TYPE("slot_material_put_type", "slotMaterialPutType", "int", "广告位素材投放方式; 0-人工 1-算法1.0 2-算法2.0 3-算法返回null降级"),

    //插件投放类型 1-分流算法3.0，2-配置大盘默认，3-配置活动，4-配置广告位定制，5-配置算法，6-盘古，7-分流算法2.0
    PLUGIN_PUT_TYPE("plugin_put_type", "pluginPutType", "int", "插件投放类型; 1-分流算法3.0，2-配置大盘默认，3-配置活动，4-配置广告位定制，5-配置算法，6-盘古，7-分流算法2.0"),

    //媒体一级行业
    APP_FIRST_TRADE_ID("app_first_trade_id", "appFirstTradeId", "int", "媒体一级行业"),

    //媒体二级行业
    APP_SECOND_TRADE_ID("app_second_trade_id", "appSecondTradeId", "int", "媒体二级行业"),

    //媒体流量标签
    APP_FLOW_TAG("app_flow_tag", "appFlowTag", "int", "媒体流量标签"),

    //广告行业
    ADVERT_TRADE_TAG_ID("advert_trade_tag_id", "advertTradeTagId", "int", "广告行业"),

    //媒体账号id
    DEVELOPER_ID("developer_id", "developerId", "int", "媒体账号id"),

    //资源位类型 1-广告位直投,2-浮标,3-推荐弹层,4-一次返回拦截,5-谢谢参与推荐弹层 7-二次返回拦截 9-三次返回拦截
    DSM2_A("dsm2_a", "dsm2A", "int", "资源位类型; 1-广告位直投,2-浮标,3-推荐弹层,4-一次返回拦截,5-谢谢参与推荐弹层 7-二次返回拦截 9-三次返回拦截"),

    //流量类型 (1:sdk 2:adx 3:其它)
    FLOW_TYPE("flow_type", "flowType", "int", "流量类型; 1:sdk 2:adx 3:其它"),

    //sdk版本
    SDK_VERSION("sdk_version", "sdkVersion", "String", "sdk版本"),

    //补丁版本
    PATCH_VERSION("patch_version", "patchVersion", "String", "补丁版本"),

    //需要crashType数据
    CRASH_TYPE("crash_type", "crashType", "String", "奔溃类型"),

    //os_type
    UA("ua", "ua", "String", "操作系统"),

    //活动皮肤是否出激励视频 1-出 0-不出
    WITH_ENC_VEDIO("with_enc_vedio", "withEncVedio", "int", "活动皮肤是否出激励视频; 1-出 0-不出"),

    //测试平台实验组id
    TEST_GROUP_ID("test_group_id", "testGroupId", "int", "测试平台实验组id"),

    //测试平台测试层编码
    TEST_LAYER_CODE("test_layer_code", "testLayerCode", "String", "测试平台测试层编码"),

    //测试平台实验计划ID
    TEST_PLAN_ID("test_plan_id", "testPlanId", "int", "测试平台实验计划ID"),

    //广告配置过滤原因
    FILTER_TYPE("filter_type", "filterType", "String", "广告配置过滤原因"),

    //胜出广告配置的行业
    WIN_ADVERT_TRADE_ID("win_advert_trade_id", "winAdvertTradeId", "int", "胜出广告配置的行业"),

    //广告配置竞价排序分
    RANK_SCORE("rank_score", "rankScore", "int", "广告配置竞价排序分"),

    //发券场景 5：降级人工处理方式16:推啊活动配置优惠券（活动定制）84：降级中免费券（降级免费券）83:降级中付费券（降级免费券）87:新媒体试投发券日志标注81:DMP命中，发广告13:推啊活动白名单策略12:媒体白名单策略33：广告位白名单策略80:风控反作弊命中之后发广告（风控）88:风控广告位定向导量命中发广告（风控）
    LAUNCH_SCENE("launch_scene", "launchScene", "int", "发券场景"),

    //券请求场景 插件工具：11，活动工具：12，直投页（区块直投）：3，浮标：15，新激励视频：13，增值：20，dp广告：21，美团adx：4，互动直投：2
    LAUNCH_REQUEST_TYPE("launch_request_type", "launchRequestType", "int", "券请求场景"),

    //adx联盟流量媒体id
    ADX_APP_ID("adx_app_id", "adxAppId", "String", "adx联盟流量媒体id"),

    //兑吧直播业务
    //直播id
    LIVE_ID("live_id", "liveId", "int", "直播id"),

    //线索员id
    CLUE_COLLECTOR_ID("clue_collector_id", "clueCollectorId", "int", "线索员id"),

    //是否到场：0表示未到场，1表示到场
    PRESENT("present", "present", "int", "是否到场; 0表示未到场，1表示到场"),

    //是否直接邀请：0表示裂变邀请，1表示直接邀请
    DIRECTLY("directly", "directly", "int", "是否直接邀请; 0表示裂变邀请，1表示直接邀请"),

    //是否预约页预约：0表示未预约，1表示预约
    APPOINTMENT("appointment", "appointment", "int", "是否预约; 0表示未预约，1表示预约"),

    //渠道id
    CHANNEL_ID("channel_id", "channelId", "String", "渠道id"),

    //邀请类型：1-直播前邀请 2-直播中邀请 3-直播结束后邀请
    INVITATION_TYPE("invitation_type", "invitationType", "int", "邀请类型; 1-直播前邀请 2-直播中邀请 3-直播结束后邀请"),

    //互动类型：1-分享 2-关注 3-预约下一场直播
    INTERACT_TYPE("interact_type", "interactType", "int", "互动类型; 1-分享 2-关注 3-预约下一场直播"),

    //商品id
    GOODS_ID("goods_id", "goodsId", "int", "商品id"),

    //位置id，对应dmp埋点
    POSITION_ID("position_id", "positionId", "int", "位置id; 对应dmp埋点"),

    //红包id
    RED_PACKET_ID("red_packet_id", "redPacketId", "int", "红包id"),

    //是否满足收手气王条件 0:表示不满足 1:表示满足
    IS_STANDARD("is_standard", "isStandard", "int", "是否满足收手气王条件; 0:表示不满足 1:表示满足"),

    //邀请人id
    INVITER_ID("inviter_id", "inviterId", "bigint", "邀请人id"),

    //adx过滤原因
    ADX_FILTER_TYPE("adx_filter_type", "adxFilterType", "String", "广告配置过滤原因"),

    //兑吧活动埋点日志 埋点规范：http://cf.dui88.com/pages/viewpage.action?pageId=60846606
    DPM_A("dpm_a","dpmA","int","dpm_a"),

    DPM_B("dpm_b","dpmB","int","dpm_b"),

    DPM_C("dpm_c","dpmC","int","dpm_c"),

    DPM_D("dpm_d","dpmD","int","dpm_d"),

    DCM_A("dcm_a","dcmA","int","dcm_a"),

    DCM_B("dcm_b","dcmB","String","dcm_b"),

    DCM_C("dcm_c","dcmC","String","dcm_c"),

    DCM_D("dcm_d","dcmD","String","dcm_d"),

    DOM_A("dom_a","domA","int","dom_a"),

    DOM_B("dom_b","domB","int","dom_b"),

    DOM_C("dom_c","domC","int","dom_c"),

    DOM_D("dom_d","domD","int","dom_d"),

    //广告过滤原因新增字段
    //可投配置数
    USABLE_CONFIG_NUM("usable_config_num_SUM", "usableConfigNumSum","int","可投配置数"),

    //可投配置数pv
    USABLE_CONFIG_PV("usable_config_pv", "usableConfigPv","bigint","可投配置数"),

    //可投广告数
    USABLE_ADVBERT_NUM("usable_advert_num_sum", "usableAdvertNum","int","可投广告数"),

    //可投广告数pv
    USABLE_ADVERT_PV("usable_advert_pv", "usableAdvertPv","bigint","可投广告数pv"),

    //过滤阶段 1:初始有效 2:定向媒体过滤后 3:最终进入nezha
    FILTER_STAGE("filter_stage","filterStage","int", "过滤阶段;1:初始有效 2:定向媒体过滤后 3:最终进入nezha"),

    //广告互动大盘投放场景
    ADVERT_PUT_TYPE("advert_put_scene","advertPutScene","int","广告互动大盘投放场景; 80-风控反作弊命中之后发广告 81-DMP命中发广告 88-风控广告位定向导量命中发广告 83-降级中付费券 84-降级中免费券 87-新媒体试投发券日志标注 89-正常走特权库"),

    //媒体流量类型
    APP_FLOW_TYPE("app_flow_type","appFlowType","int","媒体流量类型;1-微信,2-QQ,3-支付宝,4-其他"),

    //日期
    DATE_PARTITION("date_partition","datePartition","int","日期"),

    //人群包设备号id
    DEVICE_ID("device_id","deviceId","String","设备号id"),

    //人群包id列表
    CROWD_IDS("crowd_ids","crowdIds","String","人群包id列表"),

    //deep-link类型;1-拉活 2-拉新
    DEEP_LINK_TYPE("deep_link_type","deepLinkType","String","deep-link类型;1-拉活 2-拉新"),

    //落地页替换域名
    LANDPAGE_REPLACE_URL_HOST("replace_url_host","replaceUrlHost","String","落地页替换域名"),

    ;

    //druid 中表定义的字段名称
    private final String tableFieldName;

    //结果数据对应的别名
    private final String resultFieldName;

    //hologres 表中的字段类型(String, int, bigint等等)
    private final String fieldType;

    //维度解释说明
    private final String desc;

    HologresDimensionEnum(String tableFieldName, String resultFieldName, String fieldType, String desc) {
        this.tableFieldName = tableFieldName;
        this.resultFieldName = resultFieldName;
        this.fieldType = fieldType;
        this.desc = desc;
    }

    public String getTableFieldName() {
        return tableFieldName;
    }

    public String getResultFieldName() {
        return resultFieldName;
    }

    public String getDesc() {
        return desc;
    }

    public String getFieldType() {
        return fieldType;
    }
}
