package cn.com.duiba.bigdata.common.biz.enums.tables.bigdata;

/**
 * @author liujianxue 2022-05-30
 * hologres表的所有字段说明，枚举字段需要与 HologresDimensionEnum 中的枚举字段相同
 */
public enum DuibaSaasFrontendEventClickDetailDayEnum {

    DATE_PARTITION("date_partition", "按天分区，格式：yyyyMMdd"),

    LOG_UUID("log_uuid", "唯一键"),

    UNIX_TIME("unix_time", "unix时间戳"),

    EVENT_NAME("event_name", "元事件名"),

    TRACKING_PROJECT_ID("tracking_project_id", "埋点方案id"),

    CONSUMER_ID("consumer_id", "用户唯一标识"),

    CONSUMER_TYPE("consumer_type", "用户类型"),

    CONSUMER_LEVEL("consumer_level", "用户身份，会员等级"),

    LOG_STATUS("log_status", "登录状态"),

    APP_ID("app_id", "媒体id"),

    EVENT_CONDITION("event_condition", "事件场景"),

    EVENT_ACTION("event_action", "动作 1（浏览）、2（退出）、3（点击）"),

    CHANNEL_SOURCE("channel_source", "来源渠道"),

    LIB_VERSION("lib_version", "sdk版本"),

    ACTIVITY_ID("activity_id", "活动id"),

    ACTIVITY_TYPE("activity_type", "活动类型"),

    ACTIVITY_CODE("activity_code", "活动玩法"),

    ELEMENT_TYPE("element_type", "元素类型 1（按钮）、2（弹窗）"),

    INELIGIBILITY_CONTENT("ineligibility_content", "限制原因 1（身份限制）、2（地区限制）、3（时间限制）、4（积分限制）、5（次数限制）、6（登陆限制）"),

    VIEWLIST_FROM("viewlist_from", "查看榜单渠道 1：活动首页 2：弹窗查看榜单 3：弹窗查看完成榜单"),

    GIVEUP_TYPE("giveup_type", "放弃复活类型 1：概率复活 2：积分复活"),

    UNIT_ID("unit_id", "配置项id"),


    ;


    //hologres 中表定义的字段名称
    private final String tableFieldName;

    //字段备注
    private final String desc;

    DuibaSaasFrontendEventClickDetailDayEnum(String tableFieldName, String desc) {
        this.tableFieldName = tableFieldName;
        this.desc = desc;
    }

    public String getTableFieldName() {
        return tableFieldName;
    }

    public String getDesc() {
        return desc;
    }
}
