package cn.com.duiba.bigdata.common.biz.enums.tables.bigdata_offline;

/**
 * @author xugf 2020-11-27
 * hologres表的所有字段说明，枚举字段需要与 HologresDimensionEnum 中的枚举字段相同
 */
public enum AdvertFilterConfigOfflineEnum {

    DATE_PARTITION("date_partition", "按天分区，格式：yyyyMMdd"),

    DATA_MD5("data_md5", "唯一键"),

    UNIX_TIME("unix_time", "unix时间戳"),

    INNER_GROUP("inner_group", "公司业务分类，大类"),

    INNER_TYPE("inner_type", "日志分类，小类"),

    APP_ID("app_id", "媒体id"),

    SLOT_ID("slot_id", "广告位id"),

    LAUNCH_REQUEST_TYPE("launch_request_type", "券请求场景; 插件工具：11，活动工具：12，直投页（区块直投）：3，浮标：15，新激励视频：13，增值：20，dp广告：21，美团adx：4，互动直投：2"),

    USABLE_CONFIG_NUM_SUM("usable_config_num_sum", "可投配置数"),

    USABLE_CONFIG_PV("usable_config_pv", "可投配置数pv"),

    USABLE_ADVERT_NUM_SUM("usable_advert_num_sum", "可投广告数"),

    USABLE_ADVERT_PV("usable_advert_pv", "可投广告数pv"),

    FILTER_STAGE("filter_stage", "过滤阶段; 1:初始有效 2:定向媒体过滤后 3:最终进入nezha"),

    ACTIVITY_ID("activity_id", "活动id"),

    ;

    //hologres 中表定义的字段名称
    private final String tableFieldName;

    //字段备注
    private final String desc;

    AdvertFilterConfigOfflineEnum(String tableFieldName, String desc) {
        this.tableFieldName = tableFieldName;
        this.desc = desc;
    }

    public String getTableFieldName() {
        return tableFieldName;
    }

    public String getDesc() {
        return desc;
    }
}
