package cn.com.duiba.bigdata.common.biz.utils;

import com.aliyun.oss.OSS;
import com.aliyun.oss.OSSClientBuilder;

import java.io.InputStream;

/**
 * 阿里云oss 工具类，简化开发接入
 */
public class AliOssUtil {
    //oss客户端
    private OSS ossClient = null;

    //填写Bucket所在地域对应的Endpoint
    private String endpoint;

    //阿里云ram账号秘钥
    private String accessKeyId;
    private String accessKeySecret;

    public void setEndpoint(String endpoint) {
        this.endpoint = endpoint;
    }

    public void setAccessKeyId(String accessKeyId) {
        this.accessKeyId = accessKeyId;
    }

    public void setAccessKeySecret(String accessKeySecret) {
        this.accessKeySecret = accessKeySecret;
    }

    /**
     * 获取oss客户端
     *
     * @return oss客户端
     */
    protected OSS getOssClient() {
        if (ossClient != null) {
            return ossClient;
        }

        return initOssClient();
    }

    /**
     * 初始化oss连接
     *
     * @return oss客户端
     */
    private synchronized OSS initOssClient() {
        if (ossClient != null) {
            return ossClient;
        }

        ossClient = new OSSClientBuilder().build(endpoint, accessKeyId, accessKeySecret);

        return ossClient;
    }

    /**
     * 关闭oss连接
     */
    public void close() {
        ossClient.shutdown();
    }

    /**
     * 上传数据到oss中，如果文件已经存在，会覆盖写
     *
     * @param bucketName bucket名称
     * @param objectName 文件所在的路径
     * @param input      io输入流
     */
    public void putObject(String bucketName, String objectName, InputStream input) {
        getOssClient().putObject(bucketName, objectName, input);
    }

}
