/*
 * Decompiled with CFR 0.152.
 */
package cn.com.duiba.bigdata.common.biz.utils;

import cn.com.duiba.bigdata.common.biz.utils.HbaseResultUtil;
import cn.com.duiba.bigdata.common.biz.utils.HbaseUtil;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang3.ArrayUtils;
import org.apache.hadoop.hbase.client.Result;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class HbaseDataUtil {
    private static final Logger logger = LoggerFactory.getLogger(HbaseDataUtil.class);
    private HbaseUtil hbaseUtil;
    private String DEFAULT_NAMESPACE = "default";
    private String DEFAULT_COLUMN_FAMILY = "cf";

    public void setHbaseUtil(HbaseUtil hbaseUtil) {
        this.hbaseUtil = hbaseUtil;
    }

    public HbaseUtil getHbaseUtil() {
        return this.hbaseUtil;
    }

    public Boolean exists(String tableName, String rowKey) {
        return this.exists(this.DEFAULT_NAMESPACE, tableName, rowKey);
    }

    public Boolean exists(String nameSpace, String tableName, String rowKey) {
        return this.hbaseUtil.exists(nameSpace, tableName, rowKey);
    }

    public Map<String, Boolean> existsAll(String tableName, List<String> rowKeyList) {
        return this.existsAll(this.DEFAULT_NAMESPACE, tableName, rowKeyList);
    }

    public Map<String, Boolean> existsAll(String nameSpace, String tableName, List<String> rowKeyList) {
        boolean[] results = this.hbaseUtil.existsAll(nameSpace, tableName, rowKeyList);
        if (ArrayUtils.isEmpty((boolean[])results)) {
            return null;
        }
        HashMap<String, Boolean> map = new HashMap<String, Boolean>();
        for (int i = 0; i < rowKeyList.size(); ++i) {
            String rowkey = rowKeyList.get(i);
            Boolean result = results[i];
            map.put(rowkey, result);
        }
        return map;
    }

    public String getRow(String tableName, String rowKey, String column) {
        return this.getRow(this.DEFAULT_NAMESPACE, tableName, rowKey, this.DEFAULT_COLUMN_FAMILY, column);
    }

    public String getRow(String nameSpace, String tableName, String rowKey, String family, String column) {
        Result result = this.hbaseUtil.getRow(nameSpace, tableName, rowKey, family, column);
        return HbaseResultUtil.getResultString(result, family, column);
    }

    public Map<String, String> getRow(String tableName, String rowKey, List<String> columns) {
        return this.getRow(this.DEFAULT_NAMESPACE, tableName, rowKey, this.DEFAULT_COLUMN_FAMILY, columns, false);
    }

    public Map<String, String> getRow(String tableName, String rowKey, List<String> columns, boolean lowerCamel) {
        return this.getRow(this.DEFAULT_NAMESPACE, tableName, rowKey, this.DEFAULT_COLUMN_FAMILY, columns, lowerCamel);
    }

    public <T> T getRow(String tableName, String rowKey, List<String> columns, Class<T> clazz) {
        return this.getRow(this.DEFAULT_NAMESPACE, tableName, rowKey, this.DEFAULT_COLUMN_FAMILY, columns, clazz);
    }

    public Map<String, String> getRow(String nameSpace, String tableName, String rowKey, String family, List<String> columns, boolean lowerCamel) {
        Result result = this.hbaseUtil.getRow(nameSpace, tableName, rowKey, family, columns);
        return HbaseResultUtil.getResultMap(result, family, columns, lowerCamel);
    }

    public <T> T getRow(String nameSpace, String tableName, String rowKey, String family, List<String> columns, Class<T> clazz) {
        Result result = this.hbaseUtil.getRow(nameSpace, tableName, rowKey, family, columns);
        return HbaseResultUtil.getResultMap(result, family, columns, clazz);
    }

    public Map<String, String> getRow(String tableName, String rowKey) {
        return this.getRow(this.DEFAULT_NAMESPACE, tableName, rowKey, this.DEFAULT_COLUMN_FAMILY, false);
    }

    public Map<String, String> getRow(String tableName, String rowKey, boolean lowerCamel) {
        return this.getRow(this.DEFAULT_NAMESPACE, tableName, rowKey, this.DEFAULT_COLUMN_FAMILY, lowerCamel);
    }

    public <T> T getRow(String tableName, String rowKey, Class<T> clazz) {
        return this.getRow(this.DEFAULT_NAMESPACE, tableName, rowKey, this.DEFAULT_COLUMN_FAMILY, clazz);
    }

    public Map<String, String> getRow(String nameSpace, String tableName, String rowKey, String family, boolean lowerCamel) {
        Result result = this.hbaseUtil.getRow(nameSpace, tableName, rowKey, family);
        return HbaseResultUtil.getResultMap(result, family, lowerCamel);
    }

    public <T> T getRow(String nameSpace, String tableName, String rowKey, String family, Class<T> clazz) {
        Result result = this.hbaseUtil.getRow(nameSpace, tableName, rowKey, family);
        return HbaseResultUtil.getResultMap(result, family, clazz);
    }

    public Map<String, String> getRowList(String tableName, List<String> rowKeyList, String column) {
        return this.getRowList(this.DEFAULT_NAMESPACE, tableName, rowKeyList, this.DEFAULT_COLUMN_FAMILY, column);
    }

    public Map<String, String> getRowList(String nameSpace, String tableName, List<String> rowKeyList, String family, String column) {
        Result[] results = this.hbaseUtil.getRowList(nameSpace, tableName, rowKeyList, family, column);
        return HbaseResultUtil.getResultMap(results, family, column);
    }

    public Map<String, Map<String, String>> getRowList(String tableName, List<String> rowKeyList, List<String> columns) {
        return this.getRowList(this.DEFAULT_NAMESPACE, tableName, rowKeyList, this.DEFAULT_COLUMN_FAMILY, columns, false);
    }

    public Map<String, Map<String, String>> getRowList(String tableName, List<String> rowKeyList, List<String> columns, boolean lowerCamel) {
        return this.getRowList(this.DEFAULT_NAMESPACE, tableName, rowKeyList, this.DEFAULT_COLUMN_FAMILY, columns, lowerCamel);
    }

    public <T> Map<String, T> getRowList(String tableName, List<String> rowKeyList, List<String> columns, Class<T> clazz) {
        return this.getRowList(this.DEFAULT_NAMESPACE, tableName, rowKeyList, this.DEFAULT_COLUMN_FAMILY, columns, clazz);
    }

    public Map<String, Map<String, String>> getRowList(String nameSpace, String tableName, List<String> rowKeyList, String family, List<String> columns, boolean lowerCamel) {
        Result[] results = this.hbaseUtil.getRowList(nameSpace, tableName, rowKeyList, family, columns);
        return HbaseResultUtil.getResultMap(results, family, columns, lowerCamel);
    }

    public <T> Map<String, T> getRowList(String nameSpace, String tableName, List<String> rowKeyList, String family, List<String> columns, Class<T> clazz) {
        Result[] results = this.hbaseUtil.getRowList(nameSpace, tableName, rowKeyList, family, columns);
        return HbaseResultUtil.getResultMap(results, family, columns, clazz);
    }

    public Map<String, Map<String, String>> getRowList(String tableName, List<String> rowKeyList) {
        return this.getRowList(this.DEFAULT_NAMESPACE, tableName, rowKeyList, this.DEFAULT_COLUMN_FAMILY, false);
    }

    public Map<String, Map<String, String>> getRowList(String tableName, List<String> rowKeyList, boolean lowerCamel) {
        return this.getRowList(this.DEFAULT_NAMESPACE, tableName, rowKeyList, this.DEFAULT_COLUMN_FAMILY, lowerCamel);
    }

    public <T> Map<String, T> getRowList(String tableName, List<String> rowKeyList, Class<T> clazz) {
        return this.getRowList(this.DEFAULT_NAMESPACE, tableName, rowKeyList, this.DEFAULT_COLUMN_FAMILY, clazz);
    }

    public Map<String, Map<String, String>> getRowList(String nameSpace, String tableName, List<String> rowKeyList, String family, boolean lowerCamel) {
        Result[] results = this.hbaseUtil.getRowList(nameSpace, tableName, rowKeyList, family);
        return HbaseResultUtil.getResultMap(results, family, lowerCamel);
    }

    public <T> Map<String, T> getRowList(String nameSpace, String tableName, List<String> rowKeyList, String family, Class<T> clazz) {
        Result[] results = this.hbaseUtil.getRowList(nameSpace, tableName, rowKeyList, family);
        return HbaseResultUtil.getResultMap(results, family, clazz);
    }

    public Map<String, Map<String, String>> getRowList(String tableName, Map<String, List<String>> rowKeyMap) {
        return this.getRowList(this.DEFAULT_NAMESPACE, tableName, rowKeyMap, this.DEFAULT_COLUMN_FAMILY, false);
    }

    public Map<String, Map<String, String>> getRowList(String tableName, Map<String, List<String>> rowKeyMap, boolean lowerCamel) {
        return this.getRowList(this.DEFAULT_NAMESPACE, tableName, rowKeyMap, this.DEFAULT_COLUMN_FAMILY, lowerCamel);
    }

    public <T> Map<String, T> getRowList(String tableName, Map<String, List<String>> rowKeyMap, Class<T> clazz) {
        return this.getRowList(this.DEFAULT_NAMESPACE, tableName, rowKeyMap, this.DEFAULT_COLUMN_FAMILY, clazz);
    }

    public Map<String, Map<String, String>> getRowList(String nameSpace, String tableName, Map<String, List<String>> rowKeyMap, String family, boolean lowerCamel) {
        Result[] results = this.hbaseUtil.getRowList(nameSpace, tableName, rowKeyMap, family);
        return HbaseResultUtil.getResultMap(results, family, rowKeyMap, lowerCamel);
    }

    public <T> Map<String, T> getRowList(String nameSpace, String tableName, Map<String, List<String>> rowKeyMap, String family, Class<T> clazz) {
        Result[] results = this.hbaseUtil.getRowList(nameSpace, tableName, rowKeyMap, family);
        return HbaseResultUtil.getResultMap(results, family, rowKeyMap, clazz);
    }

    public boolean insert(String tableName, String rowKey, String column, String value) {
        return this.insert(this.DEFAULT_NAMESPACE, tableName, rowKey, this.DEFAULT_COLUMN_FAMILY, column, value);
    }

    public boolean insert(String nameSpace, String tableName, String rowKey, String family, String column, String value) {
        return this.hbaseUtil.insert(nameSpace, tableName, rowKey, family, column, value);
    }

    public boolean insert(String tableName, String rowKey, Map<String, String> columns) {
        return this.insert(this.DEFAULT_NAMESPACE, tableName, rowKey, this.DEFAULT_COLUMN_FAMILY, columns);
    }

    public boolean insert(String nameSpace, String tableName, String rowKey, String family, Map<String, String> columns) {
        return this.hbaseUtil.insert(nameSpace, tableName, rowKey, family, columns);
    }

    public boolean insert(String tableName, List<String> rowkeyList, String column, String value) {
        return this.insert(this.DEFAULT_NAMESPACE, tableName, rowkeyList, this.DEFAULT_COLUMN_FAMILY, column, value);
    }

    public boolean insert(String nameSpace, String tableName, List<String> rowkeyList, String family, String column, String value) {
        return this.hbaseUtil.insert(nameSpace, tableName, rowkeyList, family, column, value);
    }

    public boolean insert(String tableName, Map<String, Map<String, String>> rowKeyMap) {
        return this.insert(this.DEFAULT_NAMESPACE, tableName, rowKeyMap, this.DEFAULT_COLUMN_FAMILY);
    }

    public boolean insert(String nameSpace, String tableName, Map<String, Map<String, String>> rowKeyMap, String family) {
        return this.hbaseUtil.insert(nameSpace, tableName, rowKeyMap, family);
    }

    public boolean insert(String tableName, Map<String, String> rowKeyMap, String column) {
        return this.hbaseUtil.insert(this.DEFAULT_NAMESPACE, tableName, rowKeyMap, this.DEFAULT_COLUMN_FAMILY, column);
    }

    public boolean insert(String nameSpace, String tableName, Map<String, String> rowKeyMap, String family, String column) {
        return this.hbaseUtil.insert(nameSpace, tableName, rowKeyMap, family, column);
    }

    public boolean deleteRow(String tableName, String rowKey, String column) {
        return this.deleteRow(this.DEFAULT_NAMESPACE, tableName, rowKey, this.DEFAULT_COLUMN_FAMILY, column);
    }

    public boolean deleteRow(String nameSpace, String tableName, String rowKey, String family, String column) {
        return this.hbaseUtil.deleteRow(nameSpace, tableName, rowKey, family, column);
    }

    public boolean deleteRow(String tableName, String rowKey, List<String> columns) {
        return this.deleteRow(this.DEFAULT_NAMESPACE, tableName, rowKey, this.DEFAULT_COLUMN_FAMILY, columns);
    }

    public boolean deleteRow(String nameSpace, String tableName, String rowKey, String family, List<String> columns) {
        return this.hbaseUtil.deleteRow(nameSpace, tableName, rowKey, family, columns);
    }

    public boolean deleteRow(String tableName, String rowKey) {
        return this.deleteRow(this.DEFAULT_NAMESPACE, tableName, rowKey, this.DEFAULT_COLUMN_FAMILY);
    }

    public boolean deleteRow(String nameSpace, String tableName, String rowKey, String family) {
        return this.hbaseUtil.deleteRow(nameSpace, tableName, rowKey, family);
    }

    public boolean deleteRowList(String tableName, List<String> rowkeyList, String column) {
        return this.deleteRowList(this.DEFAULT_NAMESPACE, tableName, rowkeyList, this.DEFAULT_COLUMN_FAMILY, column);
    }

    public boolean deleteRowList(String nameSpace, String tableName, List<String> rowkeyList, String family, String column) {
        return this.hbaseUtil.deleteRowList(nameSpace, tableName, rowkeyList, family, column);
    }

    public boolean deleteRowList(String tableName, Map<String, List<String>> rowKeyMap) {
        return this.deleteRowList(this.DEFAULT_NAMESPACE, tableName, rowKeyMap, this.DEFAULT_COLUMN_FAMILY);
    }

    public boolean deleteRowList(String nameSpace, String tableName, Map<String, List<String>> rowKeyMap, String family) {
        return this.hbaseUtil.deleteRowList(nameSpace, tableName, rowKeyMap, family);
    }

    public boolean deleteRowList(String tableName, List<String> rowkeyList) {
        return this.deleteRowList(this.DEFAULT_NAMESPACE, tableName, rowkeyList, this.DEFAULT_COLUMN_FAMILY);
    }

    public boolean deleteRowList(String nameSpace, String tableName, List<String> rowkeyList, String family) {
        return this.hbaseUtil.deleteRowList(nameSpace, tableName, rowkeyList, family);
    }
}

