/*
 * Decompiled with CFR 0.152.
 */
package cn.com.duiba.bigdata.common.biz.utils;

import cn.com.duiba.bigdata.common.biz.entity.redis.KeyIndex;
import cn.com.duiba.bigdata.common.biz.enums.DimStatisticsIndexEnum;
import cn.com.duiba.bigdata.common.biz.utils.ByValueComparator;
import cn.com.duiba.bigdata.common.biz.utils.DateFormatUtil;
import cn.com.duiba.bigdata.common.biz.utils.MD5Util;
import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.collections.MapUtils;
import org.apache.commons.lang3.ArrayUtils;
import org.apache.commons.lang3.StringUtils;
import org.joda.time.DateTime;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class BigdataUtil {
    private static final Logger log = LoggerFactory.getLogger(BigdataUtil.class);

    public static boolean numberCheck(String str) {
        return StringUtils.isNotBlank((CharSequence)str) && str.matches("[0-9]*");
    }

    public static List<String> getTimeKeyList(String key, List<String> timeList) {
        ArrayList<String> keyList = new ArrayList<String>();
        for (String time : timeList) {
            keyList.add(key + time);
        }
        return keyList;
    }

    public static JSONObject parseJson(Object content) {
        JSONObject jsonObject = null;
        if (content == null) {
            return null;
        }
        if (content instanceof String) {
            String json = (String)content;
            jsonObject = JSON.parseObject((String)json);
        } else if (content instanceof JSONObject) {
            jsonObject = (JSONObject)content;
        }
        return jsonObject;
    }

    public static String getString(JSONObject object, String key) {
        if (object == null) {
            return null;
        }
        String str = object.getString(key);
        if (StringUtils.isBlank((CharSequence)str)) {
            return null;
        }
        if ("null".equalsIgnoreCase(str)) {
            return null;
        }
        return str;
    }

    public static String getMD5HbaseRowkey(Object ... obj) {
        String key = BigdataUtil.getJoinStr(obj);
        return StringUtils.isBlank((CharSequence)key) ? null : MD5Util.computeMD5(key).substring(0, 4) + "-" + key;
    }

    public static String getJoinStr(Object ... obj) {
        return BigdataUtil.getSepJoinStr("_", obj);
    }

    public static String getSepJoinStr(String sep, Object ... obj) {
        if (obj.length == 0) {
            return "";
        }
        StringBuilder sb = new StringBuilder();
        for (Object str : obj) {
            sb.append(str).append(sep);
        }
        return sb.delete(sb.length() - sep.length(), sb.length()).toString();
    }

    public static String getStr(String ... strs) {
        StringBuilder sb = new StringBuilder();
        for (String str : strs) {
            sb.append(str);
        }
        return sb.toString();
    }

    public static void mergeRowKeyMap(Map<String, String> map, Map<String, Map<String, Long>> rowkeyColumnMap) {
        for (String rowkey : map.keySet()) {
            JSONObject newJson = JSON.parseObject((String)map.get(rowkey));
            if (rowkeyColumnMap.containsKey(rowkey)) {
                Map<String, Long> oldColumnMap = rowkeyColumnMap.get(rowkey);
                BigdataUtil.mergeMap(newJson, oldColumnMap);
                continue;
            }
            HashMap<String, Long> newColumnMap = new HashMap<String, Long>();
            for (String key : newJson.keySet()) {
                Long value = newJson.getLongValue(key);
                newColumnMap.put(key, value);
            }
            rowkeyColumnMap.put(rowkey, newColumnMap);
        }
    }

    private static void mergeMap(JSONObject newJson, Map<String, Long> oldColumnMap) {
        for (String key : newJson.keySet()) {
            Long value = newJson.getLongValue(key);
            if (oldColumnMap.containsKey(key)) {
                oldColumnMap.put(key, oldColumnMap.get(key) + value);
                continue;
            }
            oldColumnMap.put(key, value);
        }
    }

    public static List<String> getTimeList(String type, String pattern, int number, Date date) {
        ArrayList<String> list = new ArrayList<String>();
        Calendar calendar = Calendar.getInstance();
        for (int i = 0; i < number; ++i) {
            calendar.setTime(date);
            if ("day".equals(type)) {
                calendar.add(5, -i);
            } else if ("hour".equals(type)) {
                calendar.add(11, -i);
            } else if ("minute".equals(type)) {
                calendar.add(12, -i);
            }
            list.add(DateFormatUtil.format(pattern, calendar.getTime()));
        }
        return list;
    }

    public static List<String> getTimeList(String pattern, int before) {
        DateTime dateTime = new DateTime();
        ArrayList<String> timeList = new ArrayList<String>();
        for (int i = 0; i < before; ++i) {
            if ("yyyyMMdd".equals(pattern)) {
                timeList.add(dateTime.plusDays(-i).toString(pattern));
                continue;
            }
            if ("yyyyMMddHH".equals(pattern)) {
                timeList.add(dateTime.plusHours(-i).toString(pattern));
                continue;
            }
            if (!"yyyyMMddHHmm".equals(pattern)) continue;
            timeList.add(dateTime.plusMinutes(-i).toString(pattern));
        }
        return timeList;
    }

    public static String[] getTimeArray(int before, String pattern) {
        DateTime dateTime = new DateTime();
        String[] times = new String[before];
        for (int i = 1; i <= before; ++i) {
            times[i - 1] = dateTime.plusMinutes(-i).toString(pattern);
        }
        return times;
    }

    public static <T> Map<String, Long> getBackendCntMap(Map<String, T> data) {
        HashMap<String, Long> map = new HashMap<String, Long>();
        try {
            for (String key : data.keySet()) {
                if (!BigdataUtil.numberCheck(key)) continue;
                map.put(key, Long.valueOf(data.get(key).toString()));
            }
        }
        catch (NumberFormatException e) {
            log.error("get backend data error", (Throwable)e);
        }
        return map;
    }

    public static <T extends Number> String division(T dividend, T divisor, int digit) {
        String result = "0";
        try {
            if (dividend != null && divisor != null) {
                double divisorDouble = divisor.doubleValue();
                double dividendDouble = dividend.doubleValue();
                if (divisorDouble != 0.0) {
                    result = BigDecimal.valueOf(dividendDouble / divisorDouble).setScale(digit, 4).stripTrailingZeros().toPlainString();
                }
            }
        }
        catch (Exception e) {
            log.error("division error", (Throwable)e);
        }
        return result;
    }

    public static Number add(Object v1, Object v2, Class<?> clazz) {
        if (v1 == null && v2 == null) {
            return null;
        }
        if (v1 == null) {
            return (Number)v2;
        }
        if (v2 == null) {
            return (Number)v1;
        }
        if (Double.class.isAssignableFrom(clazz)) {
            BigDecimal add = new BigDecimal(v1.toString()).add(new BigDecimal(v2.toString()));
            return Double.valueOf(add.toString());
        }
        if (Integer.class.isAssignableFrom(clazz)) {
            return Integer.valueOf(v1.toString()) + Integer.valueOf(v2.toString());
        }
        if (Long.class.isAssignableFrom(clazz)) {
            return Long.valueOf(v1.toString()) + Long.valueOf(v2.toString());
        }
        return null;
    }

    public static String getBigdataRedisKey(String prefix, String suffix, Object ... array) {
        if (StringUtils.isBlank((CharSequence)prefix)) {
            log.error("GetRedisKeyUDF prefix is null");
            return null;
        }
        if (array == null || array.length == 0) {
            return prefix + "_" + suffix;
        }
        if (array.length % 2 != 0) {
            log.error("GetRedisKeyUDF eval, array.length % 2 != 0");
            return null;
        }
        ArrayList<KeyIndex> list = new ArrayList<KeyIndex>();
        for (int i = 0; i < array.length; i += 2) {
            String key = null;
            String value = null;
            if (array[i] != null) {
                key = array[i].toString();
            }
            if (array[i + 1] != null) {
                value = array[i + 1].toString();
            }
            if (StringUtils.isAnyBlank((CharSequence[])new CharSequence[]{key, value})) {
                return null;
            }
            Integer index = DimStatisticsIndexEnum.INSTANCE.getDimIndex(key);
            if (index == null) {
                log.error("key = {} is error, please check it.", (Object)key);
                return null;
            }
            KeyIndex keyIndex = new KeyIndex(key, value, index);
            list.add(keyIndex);
        }
        Collections.sort(list);
        StringBuilder sb = new StringBuilder();
        sb.append(prefix.toUpperCase()).append("_");
        for (KeyIndex info : list) {
            sb.append(info.getValue()).append("_");
        }
        if (StringUtils.isNotBlank((CharSequence)suffix)) {
            sb.append(suffix);
        }
        return sb.toString();
    }

    public static String reverse(String str) {
        return new StringBuilder(str).reverse().toString();
    }

    public static void putHbaseColumnData(Map<String, String> map, String column, String value) {
        if (StringUtils.isNotBlank((CharSequence)value)) {
            map.put(column, value);
        }
    }

    public static String parseUrlParam(String str, String key) {
        if (StringUtils.isNotBlank((CharSequence)str)) {
            if (!str.startsWith(key)) {
                key = "&" + key;
            }
            if (str.contains(key)) {
                return str.substring(0, (str = str.substring(str.indexOf(key) + key.length())).contains("&") ? str.indexOf("&") : str.length());
            }
        }
        return null;
    }

    public static <T extends Number> Double avg(List<T> set, boolean skip) {
        int i = 0;
        double result = 0.0;
        for (Number num : set) {
            if (num == null) continue;
            double value = num.doubleValue();
            if (skip && value == 0.0) continue;
            ++i;
            result += value;
        }
        if (i != 0) {
            return result / (double)i;
        }
        return 0.0;
    }

    public static Map<String, Long> mergeData(List<String> keyList, Map<String, Map<String, String>> dataMap) {
        HashMap<String, Long> mergeMap = new HashMap<String, Long>();
        for (String key : keyList) {
            Map<String, String> data = dataMap.get(key);
            if (MapUtils.isEmpty(data)) continue;
            for (String field : data.keySet()) {
                mergeMap.put(field, mergeMap.getOrDefault(field, 0L) + BigDecimal.valueOf(Double.valueOf(data.get(field))).longValue());
            }
        }
        return mergeMap;
    }

    public static <T extends Number> Map<String, T> mergeData(List<String> keyList, Map<String, Map<String, String>> dataMap, Class<T> clazz) {
        HashMap<String, Object> mergeMap = new HashMap<String, Object>();
        for (String key : keyList) {
            Map<String, String> data = dataMap.get(key);
            if (MapUtils.isEmpty(data)) continue;
            for (String field : data.keySet()) {
                Number oldValue = (Number)mergeMap.getOrDefault(field, BigdataUtil.getValue("0", clazz));
                Number newValue = (Number)BigdataUtil.getValue(data.get(field), clazz);
                mergeMap.put(field, BigdataUtil.add(oldValue, newValue, clazz));
            }
        }
        return mergeMap;
    }

    public static <X, Y> Map<X, Y> mergeResultMap(Map<X, Y> ... resultMap) {
        if (resultMap == null || resultMap.length == 0) {
            return null;
        }
        HashMap<X, Y> dataMap = new HashMap<X, Y>();
        for (Map<X, Y> map : resultMap) {
            dataMap.putAll(map);
        }
        return dataMap;
    }

    public static Map<String, Long> mergeMaps(Collection<Map<String, String>> maps) {
        HashMap<String, Long> map = new HashMap<String, Long>();
        for (Map<String, String> ite : maps) {
            for (Map.Entry<String, String> entry : ite.entrySet()) {
                String key = entry.getKey();
                Long value = Long.parseLong(entry.getValue());
                if (map.containsKey(key)) {
                    map.put(key, (Long)map.get(key) + value);
                    continue;
                }
                map.put(key, value);
            }
        }
        return map;
    }

    public static <K, T> void putMapNotNull(Map<K, T> map, K key, T value) {
        if (map == null || key == null || value == null) {
            return;
        }
        if (value instanceof String && StringUtils.isBlank((CharSequence)((String)value))) {
            return;
        }
        if (value instanceof Collection && CollectionUtils.isEmpty((Collection)((Collection)value))) {
            return;
        }
        if (value instanceof Map && MapUtils.isEmpty((Map)((Map)value))) {
            return;
        }
        map.put(key, value);
    }

    public static String getHbaseJoinStr(Object ... obj) {
        return BigdataUtil.getSepJoinStr("-", obj);
    }

    public static boolean checkImei(String imei) {
        if (StringUtils.isBlank((CharSequence)imei) || imei.length() != 15 || !StringUtils.isNumeric((CharSequence)imei)) {
            return false;
        }
        String data = imei.substring(0, 14);
        int sum1 = 0;
        int sum2 = 0;
        for (int i = 0; i < data.length(); ++i) {
            int num = data.charAt(i) - 48;
            if (i % 2 == 0) {
                sum1 += num;
                continue;
            }
            int temp = num * 2;
            if (temp < 10) {
                sum2 += temp;
                continue;
            }
            sum2 = sum2 + temp + 1 - 10;
        }
        int total = sum1 + sum2;
        String resultStr = total % 10 == 0 ? data + "0" : data + (10 - total % 10) + "";
        return imei.equals(resultStr);
    }

    public static <K, T> List<K> getMapTopN(Map<K, T> map, Integer n, String type) {
        ArrayList<K> keyList = new ArrayList<K>(map.keySet());
        Collections.sort(keyList, new ByValueComparator<K, T>(map));
        if ("asc".equals(type)) {
            Collections.reverse(keyList);
        }
        return BigdataUtil.searchList(keyList, n);
    }

    private static <K> List<K> searchList(List<K> keyList, Integer n) {
        if (n == null || n == 0) {
            return keyList;
        }
        ArrayList<K> valueList = new ArrayList<K>();
        if (keyList.size() <= n) {
            valueList.addAll(keyList);
        } else {
            valueList.addAll(keyList.subList(0, n));
        }
        return valueList;
    }

    public static <K, V> Map<K, V> jsonToMap(String jsonStr, Class<K> keyClazz, Class<V> valueClazz) {
        HashMap<K, V> map = new HashMap<K, V>();
        JSONObject json = JSON.parseObject((String)jsonStr);
        for (String key : json.keySet()) {
            String value = json.getString(key);
            if (StringUtils.isBlank((CharSequence)value)) continue;
            map.put(BigdataUtil.getValue(key, keyClazz), BigdataUtil.getValue(value, valueClazz));
        }
        return map;
    }

    public static <X, Y, K, V> Map<K, V> mapToMap(Map<X, Y> srcMap, Class<K> keyClazz, Class<V> valueClazz) {
        HashMap<K, V> map = new HashMap<K, V>();
        for (Map.Entry<X, Y> entry : srcMap.entrySet()) {
            X key = entry.getKey();
            Y value = entry.getValue();
            if (key == null || value == null) continue;
            map.put(BigdataUtil.getValue(key.toString(), keyClazz), BigdataUtil.getValue(value.toString(), valueClazz));
        }
        return map;
    }

    public static <T> T getValue(String value, Class<T> clazz) {
        if (String.class.isAssignableFrom(clazz)) {
            return (T)value;
        }
        if (Integer.class.isAssignableFrom(clazz)) {
            return (T)Integer.valueOf(value);
        }
        if (Long.class.isAssignableFrom(clazz)) {
            return (T)Long.valueOf(value);
        }
        if (Double.class.isAssignableFrom(clazz)) {
            return (T)Double.valueOf(value);
        }
        if (Float.class.isAssignableFrom(clazz)) {
            return (T)Float.valueOf(value);
        }
        return null;
    }

    public static <T> Set<T> arrayToSet(String[] array, Class<T> clazz) {
        HashSet<T> set = new HashSet<T>();
        if (ArrayUtils.isEmpty((Object[])array)) {
            return set;
        }
        for (String s : array) {
            set.add(BigdataUtil.getValue(s, clazz));
        }
        return set;
    }

    public static <T> Set<T> strToSet(String str, String separator, Class<T> clazz) {
        if (StringUtils.isBlank((CharSequence)str)) {
            return new HashSet();
        }
        return BigdataUtil.arrayToSet(StringUtils.split((String)str, (String)separator), clazz);
    }

    public static <T> T getOptionalResult(Optional<T> opt) {
        return opt.isPresent() ? (T)opt.get() : null;
    }

    public static Long strToLong(String t) {
        if (StringUtils.isBlank((CharSequence)t)) {
            return 0L;
        }
        return Long.valueOf(t);
    }

    public static Long getLongValue(Long v) {
        if (v == null) {
            return 0L;
        }
        return v;
    }
}

