package cn.com.duiba.bigdata.common.biz.enums.tables.duiba_activity;

/**
 * @author xugf 2020-05-20
 * hologres表的所有字段说明，枚举字段需要与 HologresDimensionEnum 中的枚举字段相同
 */
public enum DuibaSaaSLogEnum {

    DATE_PARTITION("date_partition", "按天分区，格式：yyyyMMdd"),

    LOG_UUID("log_uuid", "唯一键"),

    UNIX_TIME("unix_time", "unix时间戳"),

    INNER_GROUP("inner_group", "公司业务分类，大类"),

    INNER_TYPE("inner_type", "日志分类，小类"),

    APP_ID("app_id", "媒体Id"),

    ACTIVITY_ID("activity_id", "活动id"),

    CONSUMER_ID("consumer_id", "用户id"),

    DUIBA_PAGE_TYPE("duiba_page_type", "页面类型标记(活动访问:501 活动参与:502 活动邀请:503 活动助力:504 活动分享:505)"),

    IS_FROM_SHARE("is_from_share", "是否从分享页进入(是:0 否:1)")
    ;


    //hologres 中表定义的字段名称
    private final String tableFieldName;

    //字段备注
    private final String desc;

    DuibaSaaSLogEnum(String tableFieldName, String desc) {
        this.tableFieldName = tableFieldName;
        this.desc = desc;
    }

    public String getTableFieldName() {
        return tableFieldName;
    }

    public String getDesc() {
        return desc;
    }
}
