package cn.com.duiba.bigdata.common.biz.dto;

import cn.com.duiba.bigdata.common.biz.enums.SortEnum;
import lombok.Data;

import java.io.Serializable;

/**
 * @author xugf 2023-11-28
 * 排序字段
 */
@Data
public class SortDto implements Serializable {

    private static final long serialVersionUID = 6773388599334209963L;

    //推啊业务线（维度列取值：TuiaDimensionEnum 指标列取值：TuiaMetricEnum、TuiaCalculateMetricEnum、TuiaCombineMetricEnum）
    private String key;

    //升序和降序，默认升序 SortEnum
    private String value = SortEnum.ASC.toString();

    public SortDto(String key) {
        this.key = key;
    }

    public SortDto(String key, String value) {
        this.key = key;
        this.value = value;
    }

}
