package cn.com.duiba.bigdata.common.biz.enums;

import cn.com.duiba.bigdata.common.biz.interfaces.CalculateMetricEnum;

import java.util.ArrayList;
import java.util.List;

/**
 * @author xugf 2023-11-27
 * 推啊业务线-计算类指标字段
 */
public enum TuiaCalculateMetricEnum implements CalculateMetricEnum {

    //广告消耗/发券pv
    ARPU("CONSUME", "LAUNCH_COUPON_PV", "case when sum(consume) = 0 or sum(launchCouponPV) = 0 then 0 else round(cast(cast(sum(consume) as float)/ sum(launchCouponPV) as numeric), 4) end", "arpu", "arpu"),

    //券计费点击pv/发券量pv
    CTR("COUPON_EFFECT_CLICK_PV", "LAUNCH_COUPON_PV", "case when sum(couponEffectClickPV) = 0 or sum(launchCouponPV) = 0 then 0 else round(cast(cast(sum(couponEffectClickPV) as float)/ sum(launchCouponPV) as numeric), 4) end", "ctr", "ctr"),


    ;


    //指标-分子
    private final String numerator;

    //指标-分母
    private final String denominator;

    //指标sql代码段
    private final String metricSql;

    //结果数据对应的别名
    private final String resultFieldName;

    //指标解释说明
    private final String desc;

    //枚举列表
    public static final List<String> enumList = new ArrayList<>();

    TuiaCalculateMetricEnum(String numerator, String denominator, String metricSql, String resultFieldName, String desc) {
        this.numerator = numerator;
        this.denominator = denominator;
        this.metricSql = metricSql;
        this.resultFieldName = resultFieldName;
        this.desc = desc;
    }

    public String getNumerator() {
        return numerator;
    }

    public String getDenominator() {
        return denominator;
    }

    public String getMetricSql() {
        return metricSql;
    }

    public String getResultFieldName() {
        return resultFieldName;
    }

    public String getDesc() {
        return desc;
    }

    static {
        TuiaCalculateMetricEnum[] values = TuiaCalculateMetricEnum.values();
        for (TuiaCalculateMetricEnum value : values) {
            enumList.add(value.toString());
        }
    }

}
